package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class ListDocumentsRequest(
    documentFilterList: Optional[Iterable[zio.aws.ssm.model.DocumentFilter]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.DocumentKeyValuesFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListDocumentsRequest = {
    import ListDocumentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
      .builder()
      .optionallyWith(
        documentFilterList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentFilterList)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListDocumentsRequest.ReadOnly =
    zio.aws.ssm.model.ListDocumentsRequest.wrap(buildAwsValue())
}
object ListDocumentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListDocumentsRequest =
      zio.aws.ssm.model.ListDocumentsRequest(
        documentFilterList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def documentFilterList
        : Optional[List[zio.aws.ssm.model.DocumentFilter.ReadOnly]]
    def filters
        : Optional[List[zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getDocumentFilterList
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.DocumentFilter.ReadOnly]] =
      AwsError.unwrapOptionField("documentFilterList", documentFilterList)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
  ) extends zio.aws.ssm.model.ListDocumentsRequest.ReadOnly {
    override val documentFilterList
        : Optional[List[zio.aws.ssm.model.DocumentFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentFilterList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentFilter.wrap(item)
          }.toList
        )
    override val filters
        : Optional[List[zio.aws.ssm.model.DocumentKeyValuesFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentKeyValuesFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListDocumentsRequest
  ): zio.aws.ssm.model.ListDocumentsRequest.ReadOnly = new Wrapper(impl)
}
