package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters._
final case class ListComplianceSummariesRequest(
    filters: Optional[Iterable[zio.aws.ssm.model.ComplianceStringFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest = {
    import ListComplianceSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListComplianceSummariesRequest.ReadOnly =
    zio.aws.ssm.model.ListComplianceSummariesRequest.wrap(buildAwsValue())
}
object ListComplianceSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListComplianceSummariesRequest =
      zio.aws.ssm.model.ListComplianceSummariesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters
        : Optional[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ComplianceStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
  ) extends zio.aws.ssm.model.ListComplianceSummariesRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.ssm.model.ComplianceStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ComplianceStringFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest
  ): zio.aws.ssm.model.ListComplianceSummariesRequest.ReadOnly = new Wrapper(
    impl
  )
}
