package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAssociationResponse(
    associationDescription: Optional[zio.aws.ssm.model.AssociationDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse = {
    import DescribeAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse
      .builder()
      .optionallyWith(
        associationDescription.map(value => value.buildAwsValue())
      )(_.associationDescription)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly =
    zio.aws.ssm.model.DescribeAssociationResponse.wrap(buildAwsValue())
}
object DescribeAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAssociationResponse =
      zio.aws.ssm.model.DescribeAssociationResponse(
        associationDescription.map(value => value.asEditable)
      )
    def associationDescription
        : Optional[zio.aws.ssm.model.AssociationDescription.ReadOnly]
    def getAssociationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.AssociationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "associationDescription",
      associationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse
  ) extends zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly {
    override val associationDescription
        : Optional[zio.aws.ssm.model.AssociationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationDescription())
        .map(value => zio.aws.ssm.model.AssociationDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse
  ): zio.aws.ssm.model.DescribeAssociationResponse.ReadOnly = new Wrapper(impl)
}
