package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  Comment,
  DeliveryTimedOutCount,
  ParameterName,
  ParameterValue,
  TimeoutSeconds,
  DocumentName,
  InstanceId,
  CommandId,
  S3Region,
  CompletedCount,
  DocumentVersion,
  S3KeyPrefix,
  DateTime,
  S3BucketName,
  ServiceRole,
  TargetCount,
  ErrorCount,
  MaxConcurrency,
  MaxErrors,
  StatusDetails
}
import scala.jdk.CollectionConverters._
final case class Command(
    commandId: Optional[CommandId] = Optional.Absent,
    documentName: Optional[DocumentName] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    comment: Optional[Comment] = Optional.Absent,
    expiresAfter: Optional[DateTime] = Optional.Absent,
    parameters: Optional[Map[ParameterName, Iterable[ParameterValue]]] =
      Optional.Absent,
    instanceIds: Optional[Iterable[InstanceId]] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    requestedDateTime: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.CommandStatus] = Optional.Absent,
    statusDetails: Optional[StatusDetails] = Optional.Absent,
    outputS3Region: Optional[S3Region] = Optional.Absent,
    outputS3BucketName: Optional[S3BucketName] = Optional.Absent,
    outputS3KeyPrefix: Optional[S3KeyPrefix] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    targetCount: Optional[TargetCount] = Optional.Absent,
    completedCount: Optional[CompletedCount] = Optional.Absent,
    errorCount: Optional[ErrorCount] = Optional.Absent,
    deliveryTimedOutCount: Optional[DeliveryTimedOutCount] = Optional.Absent,
    serviceRole: Optional[ServiceRole] = Optional.Absent,
    notificationConfig: Optional[zio.aws.ssm.model.NotificationConfig] =
      Optional.Absent,
    cloudWatchOutputConfig: Optional[zio.aws.ssm.model.CloudWatchOutputConfig] =
      Optional.Absent,
    timeoutSeconds: Optional[TimeoutSeconds] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Command = {
    import Command.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Command
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        expiresAfter.map(value => DateTime.unwrap(value): Instant)
      )(_.expiresAfter)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        requestedDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.requestedDateTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        outputS3Region.map(value => S3Region.unwrap(value): java.lang.String)
      )(_.outputS3Region)
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        targetCount.map(value => TargetCount.unwrap(value): Integer)
      )(_.targetCount)
      .optionallyWith(
        completedCount.map(value => CompletedCount.unwrap(value): Integer)
      )(_.completedCount)
      .optionallyWith(
        errorCount.map(value => ErrorCount.unwrap(value): Integer)
      )(_.errorCount)
      .optionallyWith(
        deliveryTimedOutCount.map(value =>
          DeliveryTimedOutCount.unwrap(value): Integer
        )
      )(_.deliveryTimedOutCount)
      .optionallyWith(
        serviceRole.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .optionallyWith(
        timeoutSeconds.map(value => TimeoutSeconds.unwrap(value): Integer)
      )(_.timeoutSeconds)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Command.ReadOnly =
    zio.aws.ssm.model.Command.wrap(buildAwsValue())
}
object Command {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Command] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Command = zio.aws.ssm.model.Command(
      commandId.map(value => value),
      documentName.map(value => value),
      documentVersion.map(value => value),
      comment.map(value => value),
      expiresAfter.map(value => value),
      parameters.map(value => value),
      instanceIds.map(value => value),
      targets.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      requestedDateTime.map(value => value),
      status.map(value => value),
      statusDetails.map(value => value),
      outputS3Region.map(value => value),
      outputS3BucketName.map(value => value),
      outputS3KeyPrefix.map(value => value),
      maxConcurrency.map(value => value),
      maxErrors.map(value => value),
      targetCount.map(value => value),
      completedCount.map(value => value),
      errorCount.map(value => value),
      deliveryTimedOutCount.map(value => value),
      serviceRole.map(value => value),
      notificationConfig.map(value => value.asEditable),
      cloudWatchOutputConfig.map(value => value.asEditable),
      timeoutSeconds.map(value => value)
    )
    def commandId: Optional[CommandId]
    def documentName: Optional[DocumentName]
    def documentVersion: Optional[DocumentVersion]
    def comment: Optional[Comment]
    def expiresAfter: Optional[DateTime]
    def parameters: Optional[Map[ParameterName, List[ParameterValue]]]
    def instanceIds: Optional[List[InstanceId]]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def requestedDateTime: Optional[DateTime]
    def status: Optional[zio.aws.ssm.model.CommandStatus]
    def statusDetails: Optional[StatusDetails]
    def outputS3Region: Optional[S3Region]
    def outputS3BucketName: Optional[S3BucketName]
    def outputS3KeyPrefix: Optional[S3KeyPrefix]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def targetCount: Optional[TargetCount]
    def completedCount: Optional[CompletedCount]
    def errorCount: Optional[ErrorCount]
    def deliveryTimedOutCount: Optional[DeliveryTimedOutCount]
    def serviceRole: Optional[ServiceRole]
    def notificationConfig
        : Optional[zio.aws.ssm.model.NotificationConfig.ReadOnly]
    def cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def timeoutSeconds: Optional[TimeoutSeconds]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getExpiresAfter: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("expiresAfter", expiresAfter)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getRequestedDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("requestedDateTime", requestedDateTime)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.CommandStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getOutputS3Region: ZIO[Any, AwsError, S3Region] =
      AwsError.unwrapOptionField("outputS3Region", outputS3Region)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTargetCount: ZIO[Any, AwsError, TargetCount] =
      AwsError.unwrapOptionField("targetCount", targetCount)
    def getCompletedCount: ZIO[Any, AwsError, CompletedCount] =
      AwsError.unwrapOptionField("completedCount", completedCount)
    def getErrorCount: ZIO[Any, AwsError, ErrorCount] =
      AwsError.unwrapOptionField("errorCount", errorCount)
    def getDeliveryTimedOutCount: ZIO[Any, AwsError, DeliveryTimedOutCount] =
      AwsError.unwrapOptionField("deliveryTimedOutCount", deliveryTimedOutCount)
    def getServiceRole: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getNotificationConfig
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
    def getTimeoutSeconds: ZIO[Any, AwsError, TimeoutSeconds] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Command
  ) extends zio.aws.ssm.model.Command.ReadOnly {
    override val commandId: Optional[CommandId] = zio.aws.core.internal
      .optionalFromNullable(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val documentName: Optional[DocumentName] = zio.aws.core.internal
      .optionalFromNullable(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val comment: Optional[Comment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val expiresAfter: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresAfter())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val parameters
        : Optional[Map[ParameterName, List[ParameterValue]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val instanceIds: Optional[List[InstanceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.InstanceId(item)
        }.toList
      )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val requestedDateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.requestedDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.ssm.model.CommandStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.CommandStatus.wrap(value))
    override val statusDetails: Optional[StatusDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val outputS3Region: Optional[S3Region] = zio.aws.core.internal
      .optionalFromNullable(impl.outputS3Region())
      .map(value => zio.aws.ssm.model.primitives.S3Region(value))
    override val outputS3BucketName: Optional[S3BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3BucketName())
        .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Optional[S3KeyPrefix] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3KeyPrefix())
        .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val targetCount: Optional[TargetCount] = zio.aws.core.internal
      .optionalFromNullable(impl.targetCount())
      .map(value => zio.aws.ssm.model.primitives.TargetCount(value))
    override val completedCount: Optional[CompletedCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completedCount())
        .map(value => zio.aws.ssm.model.primitives.CompletedCount(value))
    override val errorCount: Optional[ErrorCount] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCount())
      .map(value => zio.aws.ssm.model.primitives.ErrorCount(value))
    override val deliveryTimedOutCount: Optional[DeliveryTimedOutCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryTimedOutCount())
        .map(value => zio.aws.ssm.model.primitives.DeliveryTimedOutCount(value))
    override val serviceRole: Optional[ServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val notificationConfig
        : Optional[zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationConfig())
        .map(value => zio.aws.ssm.model.NotificationConfig.wrap(value))
    override val cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchOutputConfig())
        .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
    override val timeoutSeconds: Optional[TimeoutSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutSeconds())
        .map(value => zio.aws.ssm.model.primitives.TimeoutSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Command
  ): zio.aws.ssm.model.Command.ReadOnly = new Wrapper(impl)
}
