package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMaintenanceWindowExecutionRequest(
    windowExecutionId: MaintenanceWindowExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest = {
    import GetMaintenanceWindowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest
      .builder()
      .windowExecutionId(
        MaintenanceWindowExecutionId.unwrap(windowExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest.wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest(windowExecutionId)
    def windowExecutionId: MaintenanceWindowExecutionId
    def getWindowExecutionId: ZIO[Any, Nothing, MaintenanceWindowExecutionId] =
      ZIO.succeed(windowExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest.ReadOnly {
    override val windowExecutionId: MaintenanceWindowExecutionId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionId(impl.windowExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
