package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  DateTime,
  BaselineDescription,
  BaselineName,
  BaselineId,
  PatchId
}
import scala.jdk.CollectionConverters._
final case class UpdatePatchBaselineResponse(
    baselineId: Optional[BaselineId] = Optional.Absent,
    name: Optional[BaselineName] = Optional.Absent,
    operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      Optional.Absent,
    globalFilters: Optional[zio.aws.ssm.model.PatchFilterGroup] =
      Optional.Absent,
    approvalRules: Optional[zio.aws.ssm.model.PatchRuleGroup] = Optional.Absent,
    approvedPatches: Optional[Iterable[PatchId]] = Optional.Absent,
    approvedPatchesComplianceLevel: Optional[
      zio.aws.ssm.model.PatchComplianceLevel
    ] = Optional.Absent,
    approvedPatchesEnableNonSecurity: Optional[Boolean] = Optional.Absent,
    rejectedPatches: Optional[Iterable[PatchId]] = Optional.Absent,
    rejectedPatchesAction: Optional[zio.aws.ssm.model.PatchAction] =
      Optional.Absent,
    createdDate: Optional[DateTime] = Optional.Absent,
    modifiedDate: Optional[DateTime] = Optional.Absent,
    description: Optional[BaselineDescription] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.ssm.model.PatchSource]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse = {
    import UpdatePatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .optionallyWith(
        name.map(value => BaselineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(operatingSystem.map(value => value.unwrap))(
        _.operatingSystem
      )
      .optionallyWith(globalFilters.map(value => value.buildAwsValue()))(
        _.globalFilters
      )
      .optionallyWith(approvalRules.map(value => value.buildAwsValue()))(
        _.approvalRules
      )
      .optionallyWith(
        approvedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedPatches)
      .optionallyWith(
        approvedPatchesComplianceLevel.map(value => value.unwrap)
      )(_.approvedPatchesComplianceLevel)
      .optionallyWith(
        approvedPatchesEnableNonSecurity.map(value => value: java.lang.Boolean)
      )(_.approvedPatchesEnableNonSecurity)
      .optionallyWith(
        rejectedPatches.map(value =>
          value.map { item =>
            PatchId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.rejectedPatches)
      .optionallyWith(rejectedPatchesAction.map(value => value.unwrap))(
        _.rejectedPatchesAction
      )
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        modifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.modifiedDate)
      .optionallyWith(
        description.map(value =>
          BaselineDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.UpdatePatchBaselineResponse.wrap(buildAwsValue())
}
object UpdatePatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdatePatchBaselineResponse =
      zio.aws.ssm.model.UpdatePatchBaselineResponse(
        baselineId.map(value => value),
        name.map(value => value),
        operatingSystem.map(value => value),
        globalFilters.map(value => value.asEditable),
        approvalRules.map(value => value.asEditable),
        approvedPatches.map(value => value),
        approvedPatchesComplianceLevel.map(value => value),
        approvedPatchesEnableNonSecurity.map(value => value),
        rejectedPatches.map(value => value),
        rejectedPatchesAction.map(value => value),
        createdDate.map(value => value),
        modifiedDate.map(value => value),
        description.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def baselineId: Optional[BaselineId]
    def name: Optional[BaselineName]
    def operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem]
    def globalFilters: Optional[zio.aws.ssm.model.PatchFilterGroup.ReadOnly]
    def approvalRules: Optional[zio.aws.ssm.model.PatchRuleGroup.ReadOnly]
    def approvedPatches: Optional[List[PatchId]]
    def approvedPatchesComplianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel]
    def approvedPatchesEnableNonSecurity: Optional[Boolean]
    def rejectedPatches: Optional[List[PatchId]]
    def rejectedPatchesAction: Optional[zio.aws.ssm.model.PatchAction]
    def createdDate: Optional[DateTime]
    def modifiedDate: Optional[DateTime]
    def description: Optional[BaselineDescription]
    def sources: Optional[List[zio.aws.ssm.model.PatchSource.ReadOnly]]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
    def getName: ZIO[Any, AwsError, BaselineName] =
      AwsError.unwrapOptionField("name", name)
    def getOperatingSystem
        : ZIO[Any, AwsError, zio.aws.ssm.model.OperatingSystem] =
      AwsError.unwrapOptionField("operatingSystem", operatingSystem)
    def getGlobalFilters
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      AwsError.unwrapOptionField("globalFilters", globalFilters)
    def getApprovalRules
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("approvalRules", approvalRules)
    def getApprovedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("approvedPatches", approvedPatches)
    def getApprovedPatchesComplianceLevel
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchComplianceLevel] =
      AwsError.unwrapOptionField(
        "approvedPatchesComplianceLevel",
        approvedPatchesComplianceLevel
      )
    def getApprovedPatchesEnableNonSecurity: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "approvedPatchesEnableNonSecurity",
        approvedPatchesEnableNonSecurity
      )
    def getRejectedPatches: ZIO[Any, AwsError, List[PatchId]] =
      AwsError.unwrapOptionField("rejectedPatches", rejectedPatches)
    def getRejectedPatchesAction
        : ZIO[Any, AwsError, zio.aws.ssm.model.PatchAction] =
      AwsError.unwrapOptionField("rejectedPatchesAction", rejectedPatchesAction)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("modifiedDate", modifiedDate)
    def getDescription: ZIO[Any, AwsError, BaselineDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSources
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse
  ) extends zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly {
    override val baselineId: Optional[BaselineId] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
    override val name: Optional[BaselineName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.BaselineName(value))
    override val operatingSystem: Optional[zio.aws.ssm.model.OperatingSystem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystem())
        .map(value => zio.aws.ssm.model.OperatingSystem.wrap(value))
    override val globalFilters
        : Optional[zio.aws.ssm.model.PatchFilterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalFilters())
        .map(value => zio.aws.ssm.model.PatchFilterGroup.wrap(value))
    override val approvalRules
        : Optional[zio.aws.ssm.model.PatchRuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvalRules())
        .map(value => zio.aws.ssm.model.PatchRuleGroup.wrap(value))
    override val approvedPatches: Optional[List[PatchId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchId(item)
          }.toList
        )
    override val approvedPatchesComplianceLevel
        : Optional[zio.aws.ssm.model.PatchComplianceLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatchesComplianceLevel())
        .map(value => zio.aws.ssm.model.PatchComplianceLevel.wrap(value))
    override val approvedPatchesEnableNonSecurity: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedPatchesEnableNonSecurity())
        .map(value => value: Boolean)
    override val rejectedPatches: Optional[List[PatchId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rejectedPatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchId(item)
          }.toList
        )
    override val rejectedPatchesAction
        : Optional[zio.aws.ssm.model.PatchAction] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectedPatchesAction())
      .map(value => zio.aws.ssm.model.PatchAction.wrap(value))
    override val createdDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val modifiedDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.modifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val description: Optional[BaselineDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.ssm.model.primitives.BaselineDescription(value))
    override val sources
        : Optional[List[zio.aws.ssm.model.PatchSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse
  ): zio.aws.ssm.model.UpdatePatchBaselineResponse.ReadOnly = new Wrapper(impl)
}
