package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PatchOrchestratorFilterValue,
  PatchOrchestratorFilterKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PatchOrchestratorFilter(
    key: Optional[PatchOrchestratorFilterKey] = Optional.Absent,
    values: Optional[Iterable[PatchOrchestratorFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PatchOrchestratorFilter = {
    import PatchOrchestratorFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PatchOrchestratorFilter
      .builder()
      .optionallyWith(
        key.map(value =>
          PatchOrchestratorFilterKey.unwrap(value): java.lang.String
        )
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            PatchOrchestratorFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly =
    zio.aws.ssm.model.PatchOrchestratorFilter.wrap(buildAwsValue())
}
object PatchOrchestratorFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PatchOrchestratorFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PatchOrchestratorFilter =
      zio.aws.ssm.model.PatchOrchestratorFilter(
        key.map(value => value),
        values.map(value => value)
      )
    def key: Optional[PatchOrchestratorFilterKey]
    def values: Optional[List[PatchOrchestratorFilterValue]]
    def getKey: ZIO[Any, AwsError, PatchOrchestratorFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[PatchOrchestratorFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PatchOrchestratorFilter
  ) extends zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly {
    override val key: Optional[PatchOrchestratorFilterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchOrchestratorFilterKey(value)
        )
    override val values: Optional[List[PatchOrchestratorFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PatchOrchestratorFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PatchOrchestratorFilter
  ): zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly = new Wrapper(impl)
}
