package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{OpsItemRelatedItemsMaxResults, OpsItemId}
import scala.jdk.CollectionConverters._
final case class ListOpsItemRelatedItemsRequest(
    opsItemId: Optional[OpsItemId] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.OpsItemRelatedItemsFilter]] =
      Optional.Absent,
    maxResults: Optional[OpsItemRelatedItemsMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest = {
    import ListOpsItemRelatedItemsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
      .builder()
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          OpsItemRelatedItemsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.ReadOnly =
    zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.wrap(buildAwsValue())
}
object ListOpsItemRelatedItemsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsItemRelatedItemsRequest =
      zio.aws.ssm.model.ListOpsItemRelatedItemsRequest(
        opsItemId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def opsItemId: Optional[OpsItemId]
    def filters
        : Optional[List[zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly]]
    def maxResults: Optional[OpsItemRelatedItemsMaxResults]
    def nextToken: Optional[String]
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, OpsItemRelatedItemsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
  ) extends zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.ReadOnly {
    override val opsItemId: Optional[OpsItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val filters
        : Optional[List[zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemRelatedItemsFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[OpsItemRelatedItemsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.OpsItemRelatedItemsMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest
  ): zio.aws.ssm.model.ListOpsItemRelatedItemsRequest.ReadOnly = new Wrapper(
    impl
  )
}
