package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  CommandMaxResults,
  InstanceId,
  CommandId
}
import scala.jdk.CollectionConverters._
final case class ListCommandsRequest(
    commandId: Optional[CommandId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    maxResults: Optional[CommandMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.CommandFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListCommandsRequest = {
    import ListCommandsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListCommandsRequest
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        maxResults.map(value => CommandMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListCommandsRequest.ReadOnly =
    zio.aws.ssm.model.ListCommandsRequest.wrap(buildAwsValue())
}
object ListCommandsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListCommandsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListCommandsRequest =
      zio.aws.ssm.model.ListCommandsRequest(
        commandId.map(value => value),
        instanceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def commandId: Optional[CommandId]
    def instanceId: Optional[InstanceId]
    def maxResults: Optional[CommandMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ssm.model.CommandFilter.ReadOnly]]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getMaxResults: ZIO[Any, AwsError, CommandMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.CommandFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandsRequest
  ) extends zio.aws.ssm.model.ListCommandsRequest.ReadOnly {
    override val commandId: Optional[CommandId] = zio.aws.core.internal
      .optionalFromNullable(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val maxResults: Optional[CommandMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.CommandMaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val filters
        : Optional[List[zio.aws.ssm.model.CommandFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.CommandFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListCommandsRequest
  ): zio.aws.ssm.model.ListCommandsRequest.ReadOnly = new Wrapper(impl)
}
