package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetOpsItemRequest(opsItemId: OpsItemId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetOpsItemRequest = {
    import GetOpsItemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
      .builder()
      .opsItemId(OpsItemId.unwrap(opsItemId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetOpsItemRequest.ReadOnly =
    zio.aws.ssm.model.GetOpsItemRequest.wrap(buildAwsValue())
}
object GetOpsItemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetOpsItemRequest =
      zio.aws.ssm.model.GetOpsItemRequest(opsItemId)
    def opsItemId: OpsItemId
    def getOpsItemId: ZIO[Any, Nothing, OpsItemId] = ZIO.succeed(opsItemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
  ) extends zio.aws.ssm.model.GetOpsItemRequest.ReadOnly {
    override val opsItemId: OpsItemId =
      zio.aws.ssm.model.primitives.OpsItemId(impl.opsItemId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetOpsItemRequest
  ): zio.aws.ssm.model.GetOpsItemRequest.ReadOnly = new Wrapper(impl)
}
