package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAssociationsStatusResponse(
    instanceAssociationStatusInfos: Optional[
      Iterable[zio.aws.ssm.model.InstanceAssociationStatusInfo]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse = {
    import DescribeInstanceAssociationsStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse
      .builder()
      .optionallyWith(
        instanceAssociationStatusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceAssociationStatusInfos)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly =
    zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceAssociationsStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse =
      zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse(
        instanceAssociationStatusInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceAssociationStatusInfos: Optional[
      List[zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getInstanceAssociationStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "instanceAssociationStatusInfos",
      instanceAssociationStatusInfos
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse
  ) extends zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly {
    override val instanceAssociationStatusInfos: Optional[
      List[zio.aws.ssm.model.InstanceAssociationStatusInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceAssociationStatusInfos())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.InstanceAssociationStatusInfo.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse
  ): zio.aws.ssm.model.DescribeInstanceAssociationsStatusResponse.ReadOnly =
    new Wrapper(impl)
}
