package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait PlatformType {
  def unwrap: software.amazon.awssdk.services.ssm.model.PlatformType
}
object PlatformType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PlatformType
  ): zio.aws.ssm.model.PlatformType = value match {
    case software.amazon.awssdk.services.ssm.model.PlatformType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PlatformType.WINDOWS =>
      val r = Windows
      r
    case software.amazon.awssdk.services.ssm.model.PlatformType.LINUX =>
      val r = Linux
      r
    case software.amazon.awssdk.services.ssm.model.PlatformType.MAC_OS =>
      val r = MacOS
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PlatformType =
      software.amazon.awssdk.services.ssm.model.PlatformType.UNKNOWN_TO_SDK_VERSION
  }
  case object Windows extends zio.aws.ssm.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PlatformType =
      software.amazon.awssdk.services.ssm.model.PlatformType.WINDOWS
  }
  case object Linux extends zio.aws.ssm.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PlatformType =
      software.amazon.awssdk.services.ssm.model.PlatformType.LINUX
  }
  case object MacOS extends zio.aws.ssm.model.PlatformType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PlatformType =
      software.amazon.awssdk.services.ssm.model.PlatformType.MAC_OS
  }
}
