package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowId,
  OwnerInformation,
  MaintenanceWindowTargetId,
  MaintenanceWindowName,
  MaintenanceWindowDescription
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MaintenanceWindowTarget(
    windowId: Optional[MaintenanceWindowId] = Optional.Absent,
    windowTargetId: Optional[MaintenanceWindowTargetId] = Optional.Absent,
    resourceType: Optional[zio.aws.ssm.model.MaintenanceWindowResourceType] =
      Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    ownerInformation: Optional[OwnerInformation] = Optional.Absent,
    name: Optional[MaintenanceWindowName] = Optional.Absent,
    description: Optional[MaintenanceWindowDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget = {
    import MaintenanceWindowTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        windowTargetId.map(value =>
          MaintenanceWindowTargetId.unwrap(value): java.lang.String
        )
      )(_.windowTargetId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        ownerInformation.map(value =>
          OwnerInformation.unwrap(value): java.lang.String
        )
      )(_.ownerInformation)
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowTarget.wrap(buildAwsValue())
}
object MaintenanceWindowTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowTarget =
      zio.aws.ssm.model.MaintenanceWindowTarget(
        windowId.map(value => value),
        windowTargetId.map(value => value),
        resourceType.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerInformation.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def windowId: Optional[MaintenanceWindowId]
    def windowTargetId: Optional[MaintenanceWindowTargetId]
    def resourceType: Optional[zio.aws.ssm.model.MaintenanceWindowResourceType]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def ownerInformation: Optional[OwnerInformation]
    def name: Optional[MaintenanceWindowName]
    def description: Optional[MaintenanceWindowDescription]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getWindowTargetId: ZIO[Any, AwsError, MaintenanceWindowTargetId] =
      AwsError.unwrapOptionField("windowTargetId", windowTargetId)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getOwnerInformation: ZIO[Any, AwsError, OwnerInformation] =
      AwsError.unwrapOptionField("ownerInformation", ownerInformation)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget
  ) extends zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly {
    override val windowId: Optional[MaintenanceWindowId] = zio.aws.core.internal
      .optionalFromNullable(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val windowTargetId: Optional[MaintenanceWindowTargetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowTargetId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTargetId(value)
        )
    override val resourceType
        : Optional[zio.aws.ssm.model.MaintenanceWindowResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowResourceType.wrap(value)
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val ownerInformation: Optional[OwnerInformation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerInformation())
        .map(value => zio.aws.ssm.model.primitives.OwnerInformation(value))
    override val name: Optional[MaintenanceWindowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Optional[MaintenanceWindowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowTarget
  ): zio.aws.ssm.model.MaintenanceWindowTarget.ReadOnly = new Wrapper(impl)
}
