package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  IamRole,
  StatusName,
  InstanceId,
  SourceId,
  ActivationId,
  DateTime,
  ComputerName,
  Version,
  IPAddress
}
import scala.jdk.CollectionConverters._
final case class InstanceInformation(
    instanceId: Optional[InstanceId] = Optional.Absent,
    pingStatus: Optional[zio.aws.ssm.model.PingStatus] = Optional.Absent,
    lastPingDateTime: Optional[DateTime] = Optional.Absent,
    agentVersion: Optional[Version] = Optional.Absent,
    isLatestVersion: Optional[Boolean] = Optional.Absent,
    platformType: Optional[zio.aws.ssm.model.PlatformType] = Optional.Absent,
    platformName: Optional[String] = Optional.Absent,
    platformVersion: Optional[String] = Optional.Absent,
    activationId: Optional[ActivationId] = Optional.Absent,
    iamRole: Optional[IamRole] = Optional.Absent,
    registrationDate: Optional[DateTime] = Optional.Absent,
    resourceType: Optional[zio.aws.ssm.model.ResourceType] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    ipAddress: Optional[IPAddress] = Optional.Absent,
    computerName: Optional[ComputerName] = Optional.Absent,
    associationStatus: Optional[StatusName] = Optional.Absent,
    lastAssociationExecutionDate: Optional[DateTime] = Optional.Absent,
    lastSuccessfulAssociationExecutionDate: Optional[DateTime] =
      Optional.Absent,
    associationOverview: Optional[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview
    ] = Optional.Absent,
    sourceId: Optional[SourceId] = Optional.Absent,
    sourceType: Optional[zio.aws.ssm.model.SourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceInformation = {
    import InstanceInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceInformation
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(pingStatus.map(value => value.unwrap))(_.pingStatus)
      .optionallyWith(
        lastPingDateTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastPingDateTime)
      .optionallyWith(
        agentVersion.map(value => Version.unwrap(value): java.lang.String)
      )(_.agentVersion)
      .optionallyWith(isLatestVersion.map(value => value: java.lang.Boolean))(
        _.isLatestVersion
      )
      .optionallyWith(platformType.map(value => value.unwrap))(_.platformType)
      .optionallyWith(platformName.map(value => value: java.lang.String))(
        _.platformName
      )
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(
        activationId.map(value => ActivationId.unwrap(value): java.lang.String)
      )(_.activationId)
      .optionallyWith(
        iamRole.map(value => IamRole.unwrap(value): java.lang.String)
      )(_.iamRole)
      .optionallyWith(
        registrationDate.map(value => DateTime.unwrap(value): Instant)
      )(_.registrationDate)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        computerName.map(value => ComputerName.unwrap(value): java.lang.String)
      )(_.computerName)
      .optionallyWith(
        associationStatus.map(value =>
          StatusName.unwrap(value): java.lang.String
        )
      )(_.associationStatus)
      .optionallyWith(
        lastAssociationExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastAssociationExecutionDate)
      .optionallyWith(
        lastSuccessfulAssociationExecutionDate.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.lastSuccessfulAssociationExecutionDate)
      .optionallyWith(associationOverview.map(value => value.buildAwsValue()))(
        _.associationOverview
      )
      .optionallyWith(
        sourceId.map(value => SourceId.unwrap(value): java.lang.String)
      )(_.sourceId)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstanceInformation.ReadOnly =
    zio.aws.ssm.model.InstanceInformation.wrap(buildAwsValue())
}
object InstanceInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceInformation =
      zio.aws.ssm.model.InstanceInformation(
        instanceId.map(value => value),
        pingStatus.map(value => value),
        lastPingDateTime.map(value => value),
        agentVersion.map(value => value),
        isLatestVersion.map(value => value),
        platformType.map(value => value),
        platformName.map(value => value),
        platformVersion.map(value => value),
        activationId.map(value => value),
        iamRole.map(value => value),
        registrationDate.map(value => value),
        resourceType.map(value => value),
        name.map(value => value),
        ipAddress.map(value => value),
        computerName.map(value => value),
        associationStatus.map(value => value),
        lastAssociationExecutionDate.map(value => value),
        lastSuccessfulAssociationExecutionDate.map(value => value),
        associationOverview.map(value => value.asEditable),
        sourceId.map(value => value),
        sourceType.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def pingStatus: Optional[zio.aws.ssm.model.PingStatus]
    def lastPingDateTime: Optional[DateTime]
    def agentVersion: Optional[Version]
    def isLatestVersion: Optional[Boolean]
    def platformType: Optional[zio.aws.ssm.model.PlatformType]
    def platformName: Optional[String]
    def platformVersion: Optional[String]
    def activationId: Optional[ActivationId]
    def iamRole: Optional[IamRole]
    def registrationDate: Optional[DateTime]
    def resourceType: Optional[zio.aws.ssm.model.ResourceType]
    def name: Optional[String]
    def ipAddress: Optional[IPAddress]
    def computerName: Optional[ComputerName]
    def associationStatus: Optional[StatusName]
    def lastAssociationExecutionDate: Optional[DateTime]
    def lastSuccessfulAssociationExecutionDate: Optional[DateTime]
    def associationOverview: Optional[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ]
    def sourceId: Optional[SourceId]
    def sourceType: Optional[zio.aws.ssm.model.SourceType]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPingStatus: ZIO[Any, AwsError, zio.aws.ssm.model.PingStatus] =
      AwsError.unwrapOptionField("pingStatus", pingStatus)
    def getLastPingDateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastPingDateTime", lastPingDateTime)
    def getAgentVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
    def getIsLatestVersion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isLatestVersion", isLatestVersion)
    def getPlatformType: ZIO[Any, AwsError, zio.aws.ssm.model.PlatformType] =
      AwsError.unwrapOptionField("platformType", platformType)
    def getPlatformName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformName", platformName)
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getActivationId: ZIO[Any, AwsError, ActivationId] =
      AwsError.unwrapOptionField("activationId", activationId)
    def getIamRole: ZIO[Any, AwsError, IamRole] =
      AwsError.unwrapOptionField("iamRole", iamRole)
    def getRegistrationDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("registrationDate", registrationDate)
    def getResourceType: ZIO[Any, AwsError, zio.aws.ssm.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getComputerName: ZIO[Any, AwsError, ComputerName] =
      AwsError.unwrapOptionField("computerName", computerName)
    def getAssociationStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("associationStatus", associationStatus)
    def getLastAssociationExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField(
        "lastAssociationExecutionDate",
        lastAssociationExecutionDate
      )
    def getLastSuccessfulAssociationExecutionDate
        : ZIO[Any, AwsError, DateTime] = AwsError.unwrapOptionField(
      "lastSuccessfulAssociationExecutionDate",
      lastSuccessfulAssociationExecutionDate
    )
    def getAssociationOverview: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ] = AwsError.unwrapOptionField("associationOverview", associationOverview)
    def getSourceId: ZIO[Any, AwsError, SourceId] =
      AwsError.unwrapOptionField("sourceId", sourceId)
    def getSourceType: ZIO[Any, AwsError, zio.aws.ssm.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformation
  ) extends zio.aws.ssm.model.InstanceInformation.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val pingStatus: Optional[zio.aws.ssm.model.PingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pingStatus())
        .map(value => zio.aws.ssm.model.PingStatus.wrap(value))
    override val lastPingDateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastPingDateTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val agentVersion: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.agentVersion())
      .map(value => zio.aws.ssm.model.primitives.Version(value))
    override val isLatestVersion: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isLatestVersion())
      .map(value => value: Boolean)
    override val platformType: Optional[zio.aws.ssm.model.PlatformType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformType())
        .map(value => zio.aws.ssm.model.PlatformType.wrap(value))
    override val platformName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformName())
      .map(value => value: String)
    override val platformVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.platformVersion())
      .map(value => value: String)
    override val activationId: Optional[ActivationId] = zio.aws.core.internal
      .optionalFromNullable(impl.activationId())
      .map(value => zio.aws.ssm.model.primitives.ActivationId(value))
    override val iamRole: Optional[IamRole] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRole())
      .map(value => zio.aws.ssm.model.primitives.IamRole(value))
    override val registrationDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.registrationDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val resourceType: Optional[zio.aws.ssm.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.ssm.model.ResourceType.wrap(value))
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val ipAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.ssm.model.primitives.IPAddress(value))
    override val computerName: Optional[ComputerName] = zio.aws.core.internal
      .optionalFromNullable(impl.computerName())
      .map(value => zio.aws.ssm.model.primitives.ComputerName(value))
    override val associationStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.associationStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val lastAssociationExecutionDate: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAssociationExecutionDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastSuccessfulAssociationExecutionDate: Optional[DateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulAssociationExecutionDate())
        .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val associationOverview: Optional[
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationOverview())
      .map(value =>
        zio.aws.ssm.model.InstanceAggregatedAssociationOverview.wrap(value)
      )
    override val sourceId: Optional[SourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceId())
      .map(value => zio.aws.ssm.model.primitives.SourceId(value))
    override val sourceType: Optional[zio.aws.ssm.model.SourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceType())
        .map(value => zio.aws.ssm.model.SourceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceInformation
  ): zio.aws.ssm.model.InstanceInformation.ReadOnly = new Wrapper(impl)
}
