package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaxResults,
  NextToken,
  AutomationExecutionId
}
import scala.jdk.CollectionConverters._
final case class DescribeAutomationStepExecutionsRequest(
    automationExecutionId: AutomationExecutionId,
    filters: Optional[Iterable[zio.aws.ssm.model.StepExecutionFilter]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    reverseOrder: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest = {
    import DescribeAutomationStepExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest
      .builder()
      .automationExecutionId(
        AutomationExecutionId.unwrap(automationExecutionId): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(reverseOrder.map(value => value: java.lang.Boolean))(
        _.reverseOrder
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest
      .wrap(buildAwsValue())
}
object DescribeAutomationStepExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest =
      zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest(
        automationExecutionId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value),
        reverseOrder.map(value => value)
      )
    def automationExecutionId: AutomationExecutionId
    def filters: Optional[List[zio.aws.ssm.model.StepExecutionFilter.ReadOnly]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def reverseOrder: Optional[Boolean]
    def getAutomationExecutionId: ZIO[Any, Nothing, AutomationExecutionId] =
      ZIO.succeed(automationExecutionId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.StepExecutionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getReverseOrder: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest
  ) extends zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest.ReadOnly {
    override val automationExecutionId: AutomationExecutionId =
      zio.aws.ssm.model.primitives
        .AutomationExecutionId(impl.automationExecutionId())
    override val filters
        : Optional[List[zio.aws.ssm.model.StepExecutionFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.StepExecutionFilter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val reverseOrder: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest
  ): zio.aws.ssm.model.DescribeAutomationStepExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
