package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskId,
  MaintenanceWindowId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeregisterTaskFromMaintenanceWindowRequest(
    windowId: MaintenanceWindowId,
    windowTaskId: MaintenanceWindowTaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest = {
    import DeregisterTaskFromMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .windowTaskId(
        MaintenanceWindowTaskId.unwrap(windowTaskId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
      .wrap(buildAwsValue())
}
object DeregisterTaskFromMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest =
      zio.aws.ssm.model
        .DeregisterTaskFromMaintenanceWindowRequest(windowId, windowTaskId)
    def windowId: MaintenanceWindowId
    def windowTaskId: MaintenanceWindowTaskId
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
    def getWindowTaskId: ZIO[Any, Nothing, MaintenanceWindowTaskId] =
      ZIO.succeed(windowTaskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
    override val windowTaskId: MaintenanceWindowTaskId =
      zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(impl.windowTaskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest
  ): zio.aws.ssm.model.DeregisterTaskFromMaintenanceWindowRequest.ReadOnly =
    new Wrapper(impl)
}
