package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAssociationExecutionTargetsResponse(
    associationExecutionTargets: Optional[
      Iterable[zio.aws.ssm.model.AssociationExecutionTarget]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse = {
    import DescribeAssociationExecutionTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse
      .builder()
      .optionallyWith(
        associationExecutionTargets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associationExecutionTargets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse
      .wrap(buildAwsValue())
}
object DescribeAssociationExecutionTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse =
      zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse(
        associationExecutionTargets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associationExecutionTargets
        : Optional[List[zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAssociationExecutionTargets: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "associationExecutionTargets",
      associationExecutionTargets
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse
  ) extends zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly {
    override val associationExecutionTargets: Optional[
      List[zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associationExecutionTargets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.AssociationExecutionTarget.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse
  ): zio.aws.ssm.model.DescribeAssociationExecutionTargetsResponse.ReadOnly =
    new Wrapper(impl)
}
