package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowExecutionTaskId,
  MaintenanceWindowExecutionId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMaintenanceWindowExecutionTaskRequest(
    windowExecutionId: MaintenanceWindowExecutionId,
    taskId: MaintenanceWindowExecutionTaskId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest = {
    import GetMaintenanceWindowExecutionTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest
      .builder()
      .windowExecutionId(
        MaintenanceWindowExecutionId.unwrap(windowExecutionId): java.lang.String
      )
      .taskId(MaintenanceWindowExecutionTaskId.unwrap(taskId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest =
      zio.aws.ssm.model
        .GetMaintenanceWindowExecutionTaskRequest(windowExecutionId, taskId)
    def windowExecutionId: MaintenanceWindowExecutionId
    def taskId: MaintenanceWindowExecutionTaskId
    def getWindowExecutionId: ZIO[Any, Nothing, MaintenanceWindowExecutionId] =
      ZIO.succeed(windowExecutionId)
    def getTaskId: ZIO[Any, Nothing, MaintenanceWindowExecutionTaskId] =
      ZIO.succeed(taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest.ReadOnly {
    override val windowExecutionId: MaintenanceWindowExecutionId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionId(impl.windowExecutionId())
    override val taskId: MaintenanceWindowExecutionTaskId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionTaskId(impl.taskId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskRequest.ReadOnly =
    new Wrapper(impl)
}
