package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeMaintenanceWindowExecutionTaskInvocationsResponse(
    windowExecutionTaskInvocationIdentities: Optional[Iterable[
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity
    ]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse = {
    import DescribeMaintenanceWindowExecutionTaskInvocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
      .builder()
      .optionallyWith(
        windowExecutionTaskInvocationIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.windowExecutionTaskInvocationIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowExecutionTaskInvocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse =
      zio.aws.ssm.model
        .DescribeMaintenanceWindowExecutionTaskInvocationsResponse(
          windowExecutionTaskInvocationIdentities.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def windowExecutionTaskInvocationIdentities: Optional[List[
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getWindowExecutionTaskInvocationIdentities: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "windowExecutionTaskInvocationIdentities",
      windowExecutionTaskInvocationIdentities
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly {
    override val windowExecutionTaskInvocationIdentities: Optional[List[
      zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.windowExecutionTaskInvocationIdentities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.MaintenanceWindowExecutionTaskInvocationIdentity
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse.ReadOnly =
    new Wrapper(impl)
}
