package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{InstanceCount, StatusName}
import scala.jdk.CollectionConverters._
final case class AssociationOverview(
    status: Optional[StatusName] = Optional.Absent,
    detailedStatus: Optional[StatusName] = Optional.Absent,
    associationStatusAggregatedCount: Optional[Map[StatusName, InstanceCount]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationOverview = {
    import AssociationOverview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationOverview
      .builder()
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        associationStatusAggregatedCount.map(value =>
          value
            .map({ case (key, value) =>
              (StatusName.unwrap(key): java.lang.String) -> (InstanceCount
                .unwrap(value): Integer)
            })
            .asJava
        )
      )(_.associationStatusAggregatedCount)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationOverview.ReadOnly =
    zio.aws.ssm.model.AssociationOverview.wrap(buildAwsValue())
}
object AssociationOverview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationOverview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationOverview =
      zio.aws.ssm.model.AssociationOverview(
        status.map(value => value),
        detailedStatus.map(value => value),
        associationStatusAggregatedCount.map(value => value)
      )
    def status: Optional[StatusName]
    def detailedStatus: Optional[StatusName]
    def associationStatusAggregatedCount
        : Optional[Map[StatusName, InstanceCount]]
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getAssociationStatusAggregatedCount
        : ZIO[Any, AwsError, Map[StatusName, InstanceCount]] =
      AwsError.unwrapOptionField(
        "associationStatusAggregatedCount",
        associationStatusAggregatedCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationOverview
  ) extends zio.aws.ssm.model.AssociationOverview.ReadOnly {
    override val status: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val associationStatusAggregatedCount
        : Optional[Map[StatusName, InstanceCount]] = zio.aws.core.internal
      .optionalFromNullable(impl.associationStatusAggregatedCount())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.StatusName(
              key
            ) -> zio.aws.ssm.model.primitives.InstanceCount(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationOverview
  ): zio.aws.ssm.model.AssociationOverview.ReadOnly = new Wrapper(impl)
}
