package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait PatchAction {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchAction
}
object PatchAction {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchAction
  ): zio.aws.ssm.model.PatchAction = value match {
    case software.amazon.awssdk.services.ssm.model.PatchAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchAction.ALLOW_AS_DEPENDENCY =>
      val r = ALLOW_AS_DEPENDENCY
      r
    case software.amazon.awssdk.services.ssm.model.PatchAction.BLOCK =>
      val r = BLOCK
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PatchAction {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PatchAction =
      software.amazon.awssdk.services.ssm.model.PatchAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ALLOW_AS_DEPENDENCY extends zio.aws.ssm.model.PatchAction {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PatchAction =
      software.amazon.awssdk.services.ssm.model.PatchAction.ALLOW_AS_DEPENDENCY
  }
  case object BLOCK extends zio.aws.ssm.model.PatchAction {
    override def unwrap: software.amazon.awssdk.services.ssm.model.PatchAction =
      software.amazon.awssdk.services.ssm.model.PatchAction.BLOCK
  }
}
