package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{OpsFilterValue, OpsFilterKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OpsFilter(
    key: OpsFilterKey,
    values: Iterable[OpsFilterValue],
    `type`: Optional[zio.aws.ssm.model.OpsFilterOperatorType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.OpsFilter = {
    import OpsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsFilter
      .builder()
      .key(OpsFilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        OpsFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsFilter.ReadOnly =
    zio.aws.ssm.model.OpsFilter.wrap(buildAwsValue())
}
object OpsFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsFilter =
      zio.aws.ssm.model.OpsFilter(key, values, `type`.map(value => value))
    def key: OpsFilterKey
    def values: List[OpsFilterValue]
    def `type`: Optional[zio.aws.ssm.model.OpsFilterOperatorType]
    def getKey: ZIO[Any, Nothing, OpsFilterKey] = ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[OpsFilterValue]] = ZIO.succeed(values)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.OpsFilterOperatorType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsFilter
  ) extends zio.aws.ssm.model.OpsFilter.ReadOnly {
    override val key: OpsFilterKey =
      zio.aws.ssm.model.primitives.OpsFilterKey(impl.key())
    override val values: List[OpsFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.OpsFilterValue(item)
      }
      .toList
    override val `type`: Optional[zio.aws.ssm.model.OpsFilterOperatorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssm.model.OpsFilterOperatorType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsFilter
  ): zio.aws.ssm.model.OpsFilter.ReadOnly = new Wrapper(impl)
}
