package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{DocumentVersionNumber, DocumentName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateDocumentDefaultVersionRequest(
    name: DocumentName,
    documentVersion: DocumentVersionNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest = {
    import UpdateDocumentDefaultVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .documentVersion(
        DocumentVersionNumber.unwrap(documentVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest.ReadOnly =
    zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest.wrap(buildAwsValue())
}
object UpdateDocumentDefaultVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest =
      zio.aws.ssm.model
        .UpdateDocumentDefaultVersionRequest(name, documentVersion)
    def name: DocumentName
    def documentVersion: DocumentVersionNumber
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, Nothing, DocumentVersionNumber] =
      ZIO.succeed(documentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest
  ) extends zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val documentVersion: DocumentVersionNumber =
      zio.aws.ssm.model.primitives.DocumentVersionNumber(impl.documentVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest
  ): zio.aws.ssm.model.UpdateDocumentDefaultVersionRequest.ReadOnly =
    new Wrapper(impl)
}
