package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAssociationResponse(
    associationDescription: Optional[zio.aws.ssm.model.AssociationDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse = {
    import UpdateAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse
      .builder()
      .optionallyWith(
        associationDescription.map(value => value.buildAwsValue())
      )(_.associationDescription)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly =
    zio.aws.ssm.model.UpdateAssociationResponse.wrap(buildAwsValue())
}
object UpdateAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateAssociationResponse =
      zio.aws.ssm.model.UpdateAssociationResponse(
        associationDescription.map(value => value.asEditable)
      )
    def associationDescription
        : Optional[zio.aws.ssm.model.AssociationDescription.ReadOnly]
    def getAssociationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.AssociationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "associationDescription",
      associationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse
  ) extends zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly {
    override val associationDescription
        : Optional[zio.aws.ssm.model.AssociationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationDescription())
        .map(value => zio.aws.ssm.model.AssociationDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse
  ): zio.aws.ssm.model.UpdateAssociationResponse.ReadOnly = new Wrapper(impl)
}
