package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  OpsMetadataFilterValue,
  OpsMetadataFilterKey
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OpsMetadataFilter(
    key: OpsMetadataFilterKey,
    values: Iterable[OpsMetadataFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsMetadataFilter = {
    import OpsMetadataFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsMetadataFilter
      .builder()
      .key(OpsMetadataFilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        OpsMetadataFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsMetadataFilter.ReadOnly =
    zio.aws.ssm.model.OpsMetadataFilter.wrap(buildAwsValue())
}
object OpsMetadataFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsMetadataFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsMetadataFilter =
      zio.aws.ssm.model.OpsMetadataFilter(key, values)
    def key: OpsMetadataFilterKey
    def values: List[OpsMetadataFilterValue]
    def getKey: ZIO[Any, Nothing, OpsMetadataFilterKey] = ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[OpsMetadataFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsMetadataFilter
  ) extends zio.aws.ssm.model.OpsMetadataFilter.ReadOnly {
    override val key: OpsMetadataFilterKey =
      zio.aws.ssm.model.primitives.OpsMetadataFilterKey(impl.key())
    override val values: List[OpsMetadataFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.OpsMetadataFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsMetadataFilter
  ): zio.aws.ssm.model.OpsMetadataFilter.ReadOnly = new Wrapper(impl)
}
