package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOpsItemRelatedItemsResponse(
    nextToken: Optional[String] = Optional.Absent,
    summaries: Optional[Iterable[zio.aws.ssm.model.OpsItemRelatedItemSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse = {
    import ListOpsItemRelatedItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly =
    zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.wrap(buildAwsValue())
}
object ListOpsItemRelatedItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListOpsItemRelatedItemsResponse =
      zio.aws.ssm.model.ListOpsItemRelatedItemsResponse(
        nextToken.map(value => value),
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def summaries
        : Optional[List[zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse
  ) extends zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val summaries
        : Optional[List[zio.aws.ssm.model.OpsItemRelatedItemSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsItemRelatedItemSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse
  ): zio.aws.ssm.model.ListOpsItemRelatedItemsResponse.ReadOnly = new Wrapper(
    impl
  )
}
