package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters._
final case class DescribeParametersRequest(
    filters: Optional[Iterable[zio.aws.ssm.model.ParametersFilter]] =
      Optional.Absent,
    parameterFilters: Optional[
      Iterable[zio.aws.ssm.model.ParameterStringFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeParametersRequest = {
    import DescribeParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeParametersRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        parameterFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterFilters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeParametersRequest.ReadOnly =
    zio.aws.ssm.model.DescribeParametersRequest.wrap(buildAwsValue())
}
object DescribeParametersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeParametersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeParametersRequest =
      zio.aws.ssm.model.DescribeParametersRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameterFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Optional[List[zio.aws.ssm.model.ParametersFilter.ReadOnly]]
    def parameterFilters
        : Optional[List[zio.aws.ssm.model.ParameterStringFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ParametersFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getParameterFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ParameterStringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterFilters", parameterFilters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeParametersRequest
  ) extends zio.aws.ssm.model.DescribeParametersRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.ssm.model.ParametersFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ParametersFilter.wrap(item)
          }.toList
        )
    override val parameterFilters
        : Optional[List[zio.aws.ssm.model.ParameterStringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.ParameterStringFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeParametersRequest
  ): zio.aws.ssm.model.DescribeParametersRequest.ReadOnly = new Wrapper(impl)
}
