package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  ChangeRequestName,
  AutomationParameterValue,
  ChangeDetailsValue,
  DocumentARN,
  DocumentVersion,
  AutomationParameterKey,
  DateTime,
  IdempotencyToken
}
import scala.jdk.CollectionConverters._
final case class StartChangeRequestExecutionRequest(
    scheduledTime: Optional[DateTime] = Optional.Absent,
    documentName: DocumentARN,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    parameters: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    changeRequestName: Optional[ChangeRequestName] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    autoApprove: Optional[Boolean] = Optional.Absent,
    runbooks: Iterable[zio.aws.ssm.model.Runbook],
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent,
    scheduledEndTime: Optional[DateTime] = Optional.Absent,
    changeDetails: Optional[ChangeDetailsValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest = {
    import StartChangeRequestExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest
      .builder()
      .optionallyWith(
        scheduledTime.map(value => DateTime.unwrap(value): Instant)
      )(_.scheduledTime)
      .documentName(DocumentARN.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        changeRequestName.map(value =>
          ChangeRequestName.unwrap(value): java.lang.String
        )
      )(_.changeRequestName)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(autoApprove.map(value => value: java.lang.Boolean))(
        _.autoApprove
      )
      .runbooks(runbooks.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        scheduledEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.scheduledEndTime)
      .optionallyWith(
        changeDetails.map(value =>
          ChangeDetailsValue.unwrap(value): java.lang.String
        )
      )(_.changeDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.StartChangeRequestExecutionRequest.ReadOnly =
    zio.aws.ssm.model.StartChangeRequestExecutionRequest.wrap(buildAwsValue())
}
object StartChangeRequestExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.StartChangeRequestExecutionRequest =
      zio.aws.ssm.model.StartChangeRequestExecutionRequest(
        scheduledTime.map(value => value),
        documentName,
        documentVersion.map(value => value),
        parameters.map(value => value),
        changeRequestName.map(value => value),
        clientToken.map(value => value),
        autoApprove.map(value => value),
        runbooks.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scheduledEndTime.map(value => value),
        changeDetails.map(value => value)
      )
    def scheduledTime: Optional[DateTime]
    def documentName: DocumentARN
    def documentVersion: Optional[DocumentVersion]
    def parameters
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def changeRequestName: Optional[ChangeRequestName]
    def clientToken: Optional[IdempotencyToken]
    def autoApprove: Optional[Boolean]
    def runbooks: List[zio.aws.ssm.model.Runbook.ReadOnly]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def scheduledEndTime: Optional[DateTime]
    def changeDetails: Optional[ChangeDetailsValue]
    def getScheduledTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("scheduledTime", scheduledTime)
    def getDocumentName: ZIO[Any, Nothing, DocumentARN] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getChangeRequestName: ZIO[Any, AwsError, ChangeRequestName] =
      AwsError.unwrapOptionField("changeRequestName", changeRequestName)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getAutoApprove: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoApprove", autoApprove)
    def getRunbooks
        : ZIO[Any, Nothing, List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      ZIO.succeed(runbooks)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getScheduledEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("scheduledEndTime", scheduledEndTime)
    def getChangeDetails: ZIO[Any, AwsError, ChangeDetailsValue] =
      AwsError.unwrapOptionField("changeDetails", changeDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest
  ) extends zio.aws.ssm.model.StartChangeRequestExecutionRequest.ReadOnly {
    override val scheduledTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val documentName: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.documentName())
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val parameters: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val changeRequestName: Optional[ChangeRequestName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeRequestName())
        .map(value => zio.aws.ssm.model.primitives.ChangeRequestName(value))
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.IdempotencyToken(value))
    override val autoApprove: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoApprove())
      .map(value => value: Boolean)
    override val runbooks: List[zio.aws.ssm.model.Runbook.ReadOnly] = impl
      .runbooks()
      .asScala
      .map { item =>
        zio.aws.ssm.model.Runbook.wrap(item)
      }
      .toList
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
    override val scheduledEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val changeDetails: Optional[ChangeDetailsValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeDetails())
        .map(value => zio.aws.ssm.model.primitives.ChangeDetailsValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest
  ): zio.aws.ssm.model.StartChangeRequestExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
