package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ComplianceResourceId,
  ComplianceResourceType,
  ComplianceTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceComplianceSummaryItem(
    complianceType: Optional[ComplianceTypeName] = Optional.Absent,
    resourceType: Optional[ComplianceResourceType] = Optional.Absent,
    resourceId: Optional[ComplianceResourceId] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.ComplianceStatus] = Optional.Absent,
    overallSeverity: Optional[zio.aws.ssm.model.ComplianceSeverity] =
      Optional.Absent,
    executionSummary: Optional[zio.aws.ssm.model.ComplianceExecutionSummary] =
      Optional.Absent,
    compliantSummary: Optional[zio.aws.ssm.model.CompliantSummary] =
      Optional.Absent,
    nonCompliantSummary: Optional[zio.aws.ssm.model.NonCompliantSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem = {
    import ResourceComplianceSummaryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
      .builder()
      .optionallyWith(
        complianceType.map(value =>
          ComplianceTypeName.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        resourceType.map(value =>
          ComplianceResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ComplianceResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(overallSeverity.map(value => value.unwrap))(
        _.overallSeverity
      )
      .optionallyWith(executionSummary.map(value => value.buildAwsValue()))(
        _.executionSummary
      )
      .optionallyWith(compliantSummary.map(value => value.buildAwsValue()))(
        _.compliantSummary
      )
      .optionallyWith(nonCompliantSummary.map(value => value.buildAwsValue()))(
        _.nonCompliantSummary
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly =
    zio.aws.ssm.model.ResourceComplianceSummaryItem.wrap(buildAwsValue())
}
object ResourceComplianceSummaryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceComplianceSummaryItem =
      zio.aws.ssm.model.ResourceComplianceSummaryItem(
        complianceType.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        status.map(value => value),
        overallSeverity.map(value => value),
        executionSummary.map(value => value.asEditable),
        compliantSummary.map(value => value.asEditable),
        nonCompliantSummary.map(value => value.asEditable)
      )
    def complianceType: Optional[ComplianceTypeName]
    def resourceType: Optional[ComplianceResourceType]
    def resourceId: Optional[ComplianceResourceId]
    def status: Optional[zio.aws.ssm.model.ComplianceStatus]
    def overallSeverity: Optional[zio.aws.ssm.model.ComplianceSeverity]
    def executionSummary
        : Optional[zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly]
    def compliantSummary: Optional[zio.aws.ssm.model.CompliantSummary.ReadOnly]
    def nonCompliantSummary
        : Optional[zio.aws.ssm.model.NonCompliantSummary.ReadOnly]
    def getComplianceType: ZIO[Any, AwsError, ComplianceTypeName] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getResourceType: ZIO[Any, AwsError, ComplianceResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ComplianceResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOverallSeverity
        : ZIO[Any, AwsError, zio.aws.ssm.model.ComplianceSeverity] =
      AwsError.unwrapOptionField("overallSeverity", overallSeverity)
    def getExecutionSummary: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("executionSummary", executionSummary)
    def getCompliantSummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.CompliantSummary.ReadOnly] =
      AwsError.unwrapOptionField("compliantSummary", compliantSummary)
    def getNonCompliantSummary
        : ZIO[Any, AwsError, zio.aws.ssm.model.NonCompliantSummary.ReadOnly] =
      AwsError.unwrapOptionField("nonCompliantSummary", nonCompliantSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
  ) extends zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly {
    override val complianceType: Optional[ComplianceTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value => zio.aws.ssm.model.primitives.ComplianceTypeName(value))
    override val resourceType: Optional[ComplianceResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ssm.model.primitives.ComplianceResourceType(value)
        )
    override val resourceId: Optional[ComplianceResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value => zio.aws.ssm.model.primitives.ComplianceResourceId(value))
    override val status: Optional[zio.aws.ssm.model.ComplianceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.ComplianceStatus.wrap(value))
    override val overallSeverity
        : Optional[zio.aws.ssm.model.ComplianceSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.overallSeverity())
      .map(value => zio.aws.ssm.model.ComplianceSeverity.wrap(value))
    override val executionSummary
        : Optional[zio.aws.ssm.model.ComplianceExecutionSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionSummary())
        .map(value => zio.aws.ssm.model.ComplianceExecutionSummary.wrap(value))
    override val compliantSummary
        : Optional[zio.aws.ssm.model.CompliantSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantSummary())
        .map(value => zio.aws.ssm.model.CompliantSummary.wrap(value))
    override val nonCompliantSummary
        : Optional[zio.aws.ssm.model.NonCompliantSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantSummary())
        .map(value => zio.aws.ssm.model.NonCompliantSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceComplianceSummaryItem
  ): zio.aws.ssm.model.ResourceComplianceSummaryItem.ReadOnly = new Wrapper(
    impl
  )
}
