package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ParameterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResolvedTargets(
    parameterValues: Optional[Iterable[ParameterValue]] = Optional.Absent,
    truncated: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResolvedTargets = {
    import ResolvedTargets.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResolvedTargets
      .builder()
      .optionallyWith(
        parameterValues.map(value =>
          value.map { item =>
            ParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.parameterValues)
      .optionallyWith(truncated.map(value => value: java.lang.Boolean))(
        _.truncated
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResolvedTargets.ReadOnly =
    zio.aws.ssm.model.ResolvedTargets.wrap(buildAwsValue())
}
object ResolvedTargets {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResolvedTargets
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResolvedTargets =
      zio.aws.ssm.model.ResolvedTargets(
        parameterValues.map(value => value),
        truncated.map(value => value)
      )
    def parameterValues: Optional[List[ParameterValue]]
    def truncated: Optional[Boolean]
    def getParameterValues: ZIO[Any, AwsError, List[ParameterValue]] =
      AwsError.unwrapOptionField("parameterValues", parameterValues)
    def getTruncated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("truncated", truncated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResolvedTargets
  ) extends zio.aws.ssm.model.ResolvedTargets.ReadOnly {
    override val parameterValues: Optional[List[ParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterValues())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ParameterValue(item)
          }.toList
        )
    override val truncated: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.truncated())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResolvedTargets
  ): zio.aws.ssm.model.ResolvedTargets.ReadOnly = new Wrapper(impl)
}
