package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait OpsItemRelatedItemsFilterKey {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey
}
object OpsItemRelatedItemsFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey
  ): zio.aws.ssm.model.OpsItemRelatedItemsFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.RESOURCE_TYPE =>
      val r = ResourceType
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.ASSOCIATION_ID =>
      val r = AssociationId
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.RESOURCE_URI =>
      val r = ResourceUri
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.OpsItemRelatedItemsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object ResourceType
      extends zio.aws.ssm.model.OpsItemRelatedItemsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.RESOURCE_TYPE
  }
  case object AssociationId
      extends zio.aws.ssm.model.OpsItemRelatedItemsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.ASSOCIATION_ID
  }
  case object ResourceUri
      extends zio.aws.ssm.model.OpsItemRelatedItemsFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey =
      software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilterKey.RESOURCE_URI
  }
}
