package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ServiceSettingId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceSettingRequest(settingId: ServiceSettingId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest = {
    import GetServiceSettingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest
      .builder()
      .settingId(ServiceSettingId.unwrap(settingId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetServiceSettingRequest.ReadOnly =
    zio.aws.ssm.model.GetServiceSettingRequest.wrap(buildAwsValue())
}
object GetServiceSettingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetServiceSettingRequest =
      zio.aws.ssm.model.GetServiceSettingRequest(settingId)
    def settingId: ServiceSettingId
    def getSettingId: ZIO[Any, Nothing, ServiceSettingId] =
      ZIO.succeed(settingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest
  ) extends zio.aws.ssm.model.GetServiceSettingRequest.ReadOnly {
    override val settingId: ServiceSettingId =
      zio.aws.ssm.model.primitives.ServiceSettingId(impl.settingId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest
  ): zio.aws.ssm.model.GetServiceSettingRequest.ReadOnly = new Wrapper(impl)
}
