package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePatchBaselineResponse(
    baselineId: Optional[BaselineId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse = {
    import DeletePatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse
      .builder()
      .optionallyWith(
        baselineId.map(value => BaselineId.unwrap(value): java.lang.String)
      )(_.baselineId)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.DeletePatchBaselineResponse.wrap(buildAwsValue())
}
object DeletePatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeletePatchBaselineResponse =
      zio.aws.ssm.model
        .DeletePatchBaselineResponse(baselineId.map(value => value))
    def baselineId: Optional[BaselineId]
    def getBaselineId: ZIO[Any, AwsError, BaselineId] =
      AwsError.unwrapOptionField("baselineId", baselineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse
  ) extends zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly {
    override val baselineId: Optional[BaselineId] = zio.aws.core.internal
      .optionalFromNullable(impl.baselineId())
      .map(value => zio.aws.ssm.model.primitives.BaselineId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse
  ): zio.aws.ssm.model.DeletePatchBaselineResponse.ReadOnly = new Wrapper(impl)
}
