package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PutInventoryMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutInventoryResponse(
    message: Optional[PutInventoryMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.PutInventoryResponse = {
    import PutInventoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.PutInventoryResponse
      .builder()
      .optionallyWith(
        message.map(value =>
          PutInventoryMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.PutInventoryResponse.ReadOnly =
    zio.aws.ssm.model.PutInventoryResponse.wrap(buildAwsValue())
}
object PutInventoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.PutInventoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.PutInventoryResponse =
      zio.aws.ssm.model.PutInventoryResponse(message.map(value => value))
    def message: Optional[PutInventoryMessage]
    def getMessage: ZIO[Any, AwsError, PutInventoryMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.PutInventoryResponse
  ) extends zio.aws.ssm.model.PutInventoryResponse.ReadOnly {
    override val message: Optional[PutInventoryMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.ssm.model.primitives.PutInventoryMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.PutInventoryResponse
  ): zio.aws.ssm.model.PutInventoryResponse.ReadOnly = new Wrapper(impl)
}
