package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ParameterType {
  def unwrap: software.amazon.awssdk.services.ssm.model.ParameterType
}
object ParameterType {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ParameterType
  ): zio.aws.ssm.model.ParameterType = value match {
    case software.amazon.awssdk.services.ssm.model.ParameterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ParameterType.STRING =>
      val r = String
      r
    case software.amazon.awssdk.services.ssm.model.ParameterType.STRING_LIST =>
      val r = StringList
      r
    case software.amazon.awssdk.services.ssm.model.ParameterType.SECURE_STRING =>
      val r = SecureString
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterType =
      software.amazon.awssdk.services.ssm.model.ParameterType.UNKNOWN_TO_SDK_VERSION
  }
  case object String extends zio.aws.ssm.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterType =
      software.amazon.awssdk.services.ssm.model.ParameterType.STRING
  }
  case object StringList extends zio.aws.ssm.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterType =
      software.amazon.awssdk.services.ssm.model.ParameterType.STRING_LIST
  }
  case object SecureString extends zio.aws.ssm.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParameterType =
      software.amazon.awssdk.services.ssm.model.ParameterType.SECURE_STRING
  }
}
