package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemEventFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OpsItemEventFilter(
    key: zio.aws.ssm.model.OpsItemEventFilterKey,
    values: Iterable[OpsItemEventFilterValue],
    operator: zio.aws.ssm.model.OpsItemEventFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemEventFilter = {
    import OpsItemEventFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemEventFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        OpsItemEventFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemEventFilter.ReadOnly =
    zio.aws.ssm.model.OpsItemEventFilter.wrap(buildAwsValue())
}
object OpsItemEventFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemEventFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemEventFilter =
      zio.aws.ssm.model.OpsItemEventFilter(key, values, operator)
    def key: zio.aws.ssm.model.OpsItemEventFilterKey
    def values: List[OpsItemEventFilterValue]
    def operator: zio.aws.ssm.model.OpsItemEventFilterOperator
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.OpsItemEventFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[OpsItemEventFilterValue]] =
      ZIO.succeed(values)
    def getOperator
        : ZIO[Any, Nothing, zio.aws.ssm.model.OpsItemEventFilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemEventFilter
  ) extends zio.aws.ssm.model.OpsItemEventFilter.ReadOnly {
    override val key: zio.aws.ssm.model.OpsItemEventFilterKey =
      zio.aws.ssm.model.OpsItemEventFilterKey.wrap(impl.key())
    override val values: List[OpsItemEventFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.OpsItemEventFilterValue(item)
      }
      .toList
    override val operator: zio.aws.ssm.model.OpsItemEventFilterOperator =
      zio.aws.ssm.model.OpsItemEventFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemEventFilter
  ): zio.aws.ssm.model.OpsItemEventFilter.ReadOnly = new Wrapper(impl)
}
