package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{MaxResults, NextToken, UUID}
import scala.jdk.CollectionConverters._
final case class DescribeInventoryDeletionsRequest(
    deletionId: Optional[UUID] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest = {
    import DescribeInventoryDeletionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest
      .builder()
      .optionallyWith(
        deletionId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.deletionId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribeInventoryDeletionsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInventoryDeletionsRequest.wrap(buildAwsValue())
}
object DescribeInventoryDeletionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInventoryDeletionsRequest =
      zio.aws.ssm.model.DescribeInventoryDeletionsRequest(
        deletionId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def deletionId: Optional[UUID]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getDeletionId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("deletionId", deletionId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest
  ) extends zio.aws.ssm.model.DescribeInventoryDeletionsRequest.ReadOnly {
    override val deletionId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionId())
      .map(value => zio.aws.ssm.model.primitives.UUID(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest
  ): zio.aws.ssm.model.DescribeInventoryDeletionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
