package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  PatchComplianceMaxResults,
  NextToken,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class DescribeInstancePatchStatesRequest(
    instanceIds: Iterable[InstanceId],
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[PatchComplianceMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest = {
    import DescribeInstancePatchStatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          PatchComplianceMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeInstancePatchStatesRequest.ReadOnly =
    zio.aws.ssm.model.DescribeInstancePatchStatesRequest.wrap(buildAwsValue())
}
object DescribeInstancePatchStatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeInstancePatchStatesRequest =
      zio.aws.ssm.model.DescribeInstancePatchStatesRequest(
        instanceIds,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceIds: List[InstanceId]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[PatchComplianceMaxResults]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, PatchComplianceMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest
  ) extends zio.aws.ssm.model.DescribeInstancePatchStatesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InstanceId(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[PatchComplianceMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.PatchComplianceMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest
  ): zio.aws.ssm.model.DescribeInstancePatchStatesRequest.ReadOnly =
    new Wrapper(impl)
}
