package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  AssociationId,
  StatusName,
  AssociationExecutionId,
  AssociationResourceId,
  DateTime,
  AssociationResourceType,
  AssociationVersion
}
import scala.jdk.CollectionConverters._
final case class AssociationExecutionTarget(
    associationId: Optional[AssociationId] = Optional.Absent,
    associationVersion: Optional[AssociationVersion] = Optional.Absent,
    executionId: Optional[AssociationExecutionId] = Optional.Absent,
    resourceId: Optional[AssociationResourceId] = Optional.Absent,
    resourceType: Optional[AssociationResourceType] = Optional.Absent,
    status: Optional[StatusName] = Optional.Absent,
    detailedStatus: Optional[StatusName] = Optional.Absent,
    lastExecutionDate: Optional[DateTime] = Optional.Absent,
    outputSource: Optional[zio.aws.ssm.model.OutputSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget = {
    import AssociationExecutionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        executionId.map(value =>
          AssociationExecutionId.unwrap(value): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(
        resourceId.map(value =>
          AssociationResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        resourceType.map(value =>
          AssociationResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        lastExecutionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(outputSource.map(value => value.buildAwsValue()))(
        _.outputSource
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly =
    zio.aws.ssm.model.AssociationExecutionTarget.wrap(buildAwsValue())
}
object AssociationExecutionTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationExecutionTarget =
      zio.aws.ssm.model.AssociationExecutionTarget(
        associationId.map(value => value),
        associationVersion.map(value => value),
        executionId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        status.map(value => value),
        detailedStatus.map(value => value),
        lastExecutionDate.map(value => value),
        outputSource.map(value => value.asEditable)
      )
    def associationId: Optional[AssociationId]
    def associationVersion: Optional[AssociationVersion]
    def executionId: Optional[AssociationExecutionId]
    def resourceId: Optional[AssociationResourceId]
    def resourceType: Optional[AssociationResourceType]
    def status: Optional[StatusName]
    def detailedStatus: Optional[StatusName]
    def lastExecutionDate: Optional[DateTime]
    def outputSource: Optional[zio.aws.ssm.model.OutputSource.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getExecutionId: ZIO[Any, AwsError, AssociationExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getResourceId: ZIO[Any, AwsError, AssociationResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, AssociationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getLastExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getOutputSource
        : ZIO[Any, AwsError, zio.aws.ssm.model.OutputSource.ReadOnly] =
      AwsError.unwrapOptionField("outputSource", outputSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
  ) extends zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly {
    override val associationId: Optional[AssociationId] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val associationVersion: Optional[AssociationVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationVersion())
        .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val executionId: Optional[AssociationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionId())
        .map(value =>
          zio.aws.ssm.model.primitives.AssociationExecutionId(value)
        )
    override val resourceId: Optional[AssociationResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value => zio.aws.ssm.model.primitives.AssociationResourceId(value))
    override val resourceType: Optional[AssociationResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ssm.model.primitives.AssociationResourceType(value)
        )
    override val status: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val lastExecutionDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val outputSource
        : Optional[zio.aws.ssm.model.OutputSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputSource())
        .map(value => zio.aws.ssm.model.OutputSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
  ): zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly = new Wrapper(impl)
}
