package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait PatchProperty {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchProperty
}
object PatchProperty {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchProperty
  ): zio.aws.ssm.model.PatchProperty = value match {
    case software.amazon.awssdk.services.ssm.model.PatchProperty.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchProperty.PRODUCT =>
      val r = PRODUCT
      r
    case software.amazon.awssdk.services.ssm.model.PatchProperty.PRODUCT_FAMILY =>
      val r = PRODUCT_FAMILY
      r
    case software.amazon.awssdk.services.ssm.model.PatchProperty.CLASSIFICATION =>
      val r = CLASSIFICATION
      r
    case software.amazon.awssdk.services.ssm.model.PatchProperty.MSRC_SEVERITY =>
      val r = MSRC_SEVERITY
      r
    case software.amazon.awssdk.services.ssm.model.PatchProperty.PRIORITY =>
      val r = PRIORITY
      r
    case software.amazon.awssdk.services.ssm.model.PatchProperty.SEVERITY =>
      val r = SEVERITY
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.UNKNOWN_TO_SDK_VERSION
  }
  case object PRODUCT extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.PRODUCT
  }
  case object PRODUCT_FAMILY extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.PRODUCT_FAMILY
  }
  case object CLASSIFICATION extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.CLASSIFICATION
  }
  case object MSRC_SEVERITY extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.MSRC_SEVERITY
  }
  case object PRIORITY extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.PRIORITY
  }
  case object SEVERITY extends zio.aws.ssm.model.PatchProperty {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchProperty =
      software.amazon.awssdk.services.ssm.model.PatchProperty.SEVERITY
  }
}
