package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  OpsItemId,
  DateTime,
  OpsItemType,
  OpsItemPriority,
  OpsItemSource,
  OpsItemSeverity,
  OpsItemDataKey,
  OpsItemTitle,
  OpsItemCategory
}
import scala.jdk.CollectionConverters._
final case class OpsItemSummary(
    createdBy: Optional[String] = Optional.Absent,
    createdTime: Optional[DateTime] = Optional.Absent,
    lastModifiedBy: Optional[String] = Optional.Absent,
    lastModifiedTime: Optional[DateTime] = Optional.Absent,
    priority: Optional[OpsItemPriority] = Optional.Absent,
    source: Optional[OpsItemSource] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.OpsItemStatus] = Optional.Absent,
    opsItemId: Optional[OpsItemId] = Optional.Absent,
    title: Optional[OpsItemTitle] = Optional.Absent,
    operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue]
    ] = Optional.Absent,
    category: Optional[OpsItemCategory] = Optional.Absent,
    severity: Optional[OpsItemSeverity] = Optional.Absent,
    opsItemType: Optional[OpsItemType] = Optional.Absent,
    actualStartTime: Optional[DateTime] = Optional.Absent,
    actualEndTime: Optional[DateTime] = Optional.Absent,
    plannedStartTime: Optional[DateTime] = Optional.Absent,
    plannedEndTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemSummary = {
    import OpsItemSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemSummary
      .builder()
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        createdTime.map(value => DateTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(lastModifiedBy.map(value => value: java.lang.String))(
        _.lastModifiedBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        priority.map(value => OpsItemPriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(
        source.map(value => OpsItemSource.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        opsItemId.map(value => OpsItemId.unwrap(value): java.lang.String)
      )(_.opsItemId)
      .optionallyWith(
        title.map(value => OpsItemTitle.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        operationalData.map(value =>
          value
            .map({ case (key, value) =>
              (OpsItemDataKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.operationalData)
      .optionallyWith(
        category.map(value => OpsItemCategory.unwrap(value): java.lang.String)
      )(_.category)
      .optionallyWith(
        severity.map(value => OpsItemSeverity.unwrap(value): java.lang.String)
      )(_.severity)
      .optionallyWith(
        opsItemType.map(value => OpsItemType.unwrap(value): java.lang.String)
      )(_.opsItemType)
      .optionallyWith(
        actualStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualStartTime)
      .optionallyWith(
        actualEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.actualEndTime)
      .optionallyWith(
        plannedStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedStartTime)
      .optionallyWith(
        plannedEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.plannedEndTime)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemSummary.ReadOnly =
    zio.aws.ssm.model.OpsItemSummary.wrap(buildAwsValue())
}
object OpsItemSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemSummary =
      zio.aws.ssm.model.OpsItemSummary(
        createdBy.map(value => value),
        createdTime.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedTime.map(value => value),
        priority.map(value => value),
        source.map(value => value),
        status.map(value => value),
        opsItemId.map(value => value),
        title.map(value => value),
        operationalData.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        category.map(value => value),
        severity.map(value => value),
        opsItemType.map(value => value),
        actualStartTime.map(value => value),
        actualEndTime.map(value => value),
        plannedStartTime.map(value => value),
        plannedEndTime.map(value => value)
      )
    def createdBy: Optional[String]
    def createdTime: Optional[DateTime]
    def lastModifiedBy: Optional[String]
    def lastModifiedTime: Optional[DateTime]
    def priority: Optional[OpsItemPriority]
    def source: Optional[OpsItemSource]
    def status: Optional[zio.aws.ssm.model.OpsItemStatus]
    def opsItemId: Optional[OpsItemId]
    def title: Optional[OpsItemTitle]
    def operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ]
    def category: Optional[OpsItemCategory]
    def severity: Optional[OpsItemSeverity]
    def opsItemType: Optional[OpsItemType]
    def actualStartTime: Optional[DateTime]
    def actualEndTime: Optional[DateTime]
    def plannedStartTime: Optional[DateTime]
    def plannedEndTime: Optional[DateTime]
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreatedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getPriority: ZIO[Any, AwsError, OpsItemPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSource: ZIO[Any, AwsError, OpsItemSource] =
      AwsError.unwrapOptionField("source", source)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.OpsItemStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOpsItemId: ZIO[Any, AwsError, OpsItemId] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getTitle: ZIO[Any, AwsError, OpsItemTitle] =
      AwsError.unwrapOptionField("title", title)
    def getOperationalData: ZIO[Any, AwsError, Map[
      OpsItemDataKey,
      zio.aws.ssm.model.OpsItemDataValue.ReadOnly
    ]] = AwsError.unwrapOptionField("operationalData", operationalData)
    def getCategory: ZIO[Any, AwsError, OpsItemCategory] =
      AwsError.unwrapOptionField("category", category)
    def getSeverity: ZIO[Any, AwsError, OpsItemSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getOpsItemType: ZIO[Any, AwsError, OpsItemType] =
      AwsError.unwrapOptionField("opsItemType", opsItemType)
    def getActualStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualStartTime", actualStartTime)
    def getActualEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("actualEndTime", actualEndTime)
    def getPlannedStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedStartTime", plannedStartTime)
    def getPlannedEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("plannedEndTime", plannedEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemSummary
  ) extends zio.aws.ssm.model.OpsItemSummary.ReadOnly {
    override val createdBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => value: String)
    override val createdTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedBy())
      .map(value => value: String)
    override val lastModifiedTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val priority: Optional[OpsItemPriority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.ssm.model.primitives.OpsItemPriority(value))
    override val source: Optional[OpsItemSource] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSource(value))
    override val status: Optional[zio.aws.ssm.model.OpsItemStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.OpsItemStatus.wrap(value))
    override val opsItemId: Optional[OpsItemId] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => zio.aws.ssm.model.primitives.OpsItemId(value))
    override val title: Optional[OpsItemTitle] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => zio.aws.ssm.model.primitives.OpsItemTitle(value))
    override val operationalData: Optional[
      Map[OpsItemDataKey, zio.aws.ssm.model.OpsItemDataValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationalData())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsItemDataKey(
              key
            ) -> zio.aws.ssm.model.OpsItemDataValue.wrap(value)
          })
          .toMap
      )
    override val category: Optional[OpsItemCategory] = zio.aws.core.internal
      .optionalFromNullable(impl.category())
      .map(value => zio.aws.ssm.model.primitives.OpsItemCategory(value))
    override val severity: Optional[OpsItemSeverity] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => zio.aws.ssm.model.primitives.OpsItemSeverity(value))
    override val opsItemType: Optional[OpsItemType] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemType())
      .map(value => zio.aws.ssm.model.primitives.OpsItemType(value))
    override val actualStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val actualEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.actualEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val plannedEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.plannedEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemSummary
  ): zio.aws.ssm.model.OpsItemSummary.ReadOnly = new Wrapper(impl)
}
