package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  InstancePatchStateFilterValue,
  InstancePatchStateFilterKey
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InstancePatchStateFilter(
    key: InstancePatchStateFilterKey,
    values: Iterable[InstancePatchStateFilterValue],
    `type`: zio.aws.ssm.model.InstancePatchStateOperatorType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter = {
    import InstancePatchStateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter
      .builder()
      .key(InstancePatchStateFilterKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        InstancePatchStateFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly =
    zio.aws.ssm.model.InstancePatchStateFilter.wrap(buildAwsValue())
}
object InstancePatchStateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstancePatchStateFilter =
      zio.aws.ssm.model.InstancePatchStateFilter(key, values, `type`)
    def key: InstancePatchStateFilterKey
    def values: List[InstancePatchStateFilterValue]
    def `type`: zio.aws.ssm.model.InstancePatchStateOperatorType
    def getKey: ZIO[Any, Nothing, InstancePatchStateFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[InstancePatchStateFilterValue]] =
      ZIO.succeed(values)
    def getType
        : ZIO[Any, Nothing, zio.aws.ssm.model.InstancePatchStateOperatorType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter
  ) extends zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly {
    override val key: InstancePatchStateFilterKey =
      zio.aws.ssm.model.primitives.InstancePatchStateFilterKey(impl.key())
    override val values: List[InstancePatchStateFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.InstancePatchStateFilterValue(item)
      }
      .toList
    override val `type`: zio.aws.ssm.model.InstancePatchStateOperatorType =
      zio.aws.ssm.model.InstancePatchStateOperatorType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstancePatchStateFilter
  ): zio.aws.ssm.model.InstancePatchStateFilter.ReadOnly = new Wrapper(impl)
}
