package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  Comment,
  StringDateTime,
  DocumentName,
  Url,
  InstanceId,
  CommandId,
  DocumentVersion,
  StandardOutputContent,
  ResponseCode,
  CommandPluginName,
  StandardErrorContent,
  StatusDetails
}
import scala.jdk.CollectionConverters._
final case class GetCommandInvocationResponse(
    commandId: Optional[CommandId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    comment: Optional[Comment] = Optional.Absent,
    documentName: Optional[DocumentName] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    pluginName: Optional[CommandPluginName] = Optional.Absent,
    responseCode: Optional[ResponseCode] = Optional.Absent,
    executionStartDateTime: Optional[StringDateTime] = Optional.Absent,
    executionElapsedTime: Optional[StringDateTime] = Optional.Absent,
    executionEndDateTime: Optional[StringDateTime] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.CommandInvocationStatus] =
      Optional.Absent,
    statusDetails: Optional[StatusDetails] = Optional.Absent,
    standardOutputContent: Optional[StandardOutputContent] = Optional.Absent,
    standardOutputUrl: Optional[Url] = Optional.Absent,
    standardErrorContent: Optional[StandardErrorContent] = Optional.Absent,
    standardErrorUrl: Optional[Url] = Optional.Absent,
    cloudWatchOutputConfig: Optional[zio.aws.ssm.model.CloudWatchOutputConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse = {
    import GetCommandInvocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
      .builder()
      .optionallyWith(
        commandId.map(value => CommandId.unwrap(value): java.lang.String)
      )(_.commandId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        pluginName.map(value =>
          CommandPluginName.unwrap(value): java.lang.String
        )
      )(_.pluginName)
      .optionallyWith(
        responseCode.map(value => ResponseCode.unwrap(value): Integer)
      )(_.responseCode)
      .optionallyWith(
        executionStartDateTime.map(value =>
          StringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionStartDateTime)
      .optionallyWith(
        executionElapsedTime.map(value =>
          StringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionElapsedTime)
      .optionallyWith(
        executionEndDateTime.map(value =>
          StringDateTime.unwrap(value): java.lang.String
        )
      )(_.executionEndDateTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          StatusDetails.unwrap(value): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(
        standardOutputContent.map(value =>
          StandardOutputContent.unwrap(value): java.lang.String
        )
      )(_.standardOutputContent)
      .optionallyWith(
        standardOutputUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardOutputUrl)
      .optionallyWith(
        standardErrorContent.map(value =>
          StandardErrorContent.unwrap(value): java.lang.String
        )
      )(_.standardErrorContent)
      .optionallyWith(
        standardErrorUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.standardErrorUrl)
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly =
    zio.aws.ssm.model.GetCommandInvocationResponse.wrap(buildAwsValue())
}
object GetCommandInvocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetCommandInvocationResponse =
      zio.aws.ssm.model.GetCommandInvocationResponse(
        commandId.map(value => value),
        instanceId.map(value => value),
        comment.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        pluginName.map(value => value),
        responseCode.map(value => value),
        executionStartDateTime.map(value => value),
        executionElapsedTime.map(value => value),
        executionEndDateTime.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        standardOutputContent.map(value => value),
        standardOutputUrl.map(value => value),
        standardErrorContent.map(value => value),
        standardErrorUrl.map(value => value),
        cloudWatchOutputConfig.map(value => value.asEditable)
      )
    def commandId: Optional[CommandId]
    def instanceId: Optional[InstanceId]
    def comment: Optional[Comment]
    def documentName: Optional[DocumentName]
    def documentVersion: Optional[DocumentVersion]
    def pluginName: Optional[CommandPluginName]
    def responseCode: Optional[ResponseCode]
    def executionStartDateTime: Optional[StringDateTime]
    def executionElapsedTime: Optional[StringDateTime]
    def executionEndDateTime: Optional[StringDateTime]
    def status: Optional[zio.aws.ssm.model.CommandInvocationStatus]
    def statusDetails: Optional[StatusDetails]
    def standardOutputContent: Optional[StandardOutputContent]
    def standardOutputUrl: Optional[Url]
    def standardErrorContent: Optional[StandardErrorContent]
    def standardErrorUrl: Optional[Url]
    def cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def getCommandId: ZIO[Any, AwsError, CommandId] =
      AwsError.unwrapOptionField("commandId", commandId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getPluginName: ZIO[Any, AwsError, CommandPluginName] =
      AwsError.unwrapOptionField("pluginName", pluginName)
    def getResponseCode: ZIO[Any, AwsError, ResponseCode] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getExecutionStartDateTime: ZIO[Any, AwsError, StringDateTime] = AwsError
      .unwrapOptionField("executionStartDateTime", executionStartDateTime)
    def getExecutionElapsedTime: ZIO[Any, AwsError, StringDateTime] =
      AwsError.unwrapOptionField("executionElapsedTime", executionElapsedTime)
    def getExecutionEndDateTime: ZIO[Any, AwsError, StringDateTime] =
      AwsError.unwrapOptionField("executionEndDateTime", executionEndDateTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.CommandInvocationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetails: ZIO[Any, AwsError, StatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStandardOutputContent: ZIO[Any, AwsError, StandardOutputContent] =
      AwsError.unwrapOptionField("standardOutputContent", standardOutputContent)
    def getStandardOutputUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardOutputUrl", standardOutputUrl)
    def getStandardErrorContent: ZIO[Any, AwsError, StandardErrorContent] =
      AwsError.unwrapOptionField("standardErrorContent", standardErrorContent)
    def getStandardErrorUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("standardErrorUrl", standardErrorUrl)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
  ) extends zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly {
    override val commandId: Optional[CommandId] = zio.aws.core.internal
      .optionalFromNullable(impl.commandId())
      .map(value => zio.aws.ssm.model.primitives.CommandId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val comment: Optional[Comment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val documentName: Optional[DocumentName] = zio.aws.core.internal
      .optionalFromNullable(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val pluginName: Optional[CommandPluginName] = zio.aws.core.internal
      .optionalFromNullable(impl.pluginName())
      .map(value => zio.aws.ssm.model.primitives.CommandPluginName(value))
    override val responseCode: Optional[ResponseCode] = zio.aws.core.internal
      .optionalFromNullable(impl.responseCode())
      .map(value => zio.aws.ssm.model.primitives.ResponseCode(value))
    override val executionStartDateTime: Optional[StringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStartDateTime())
        .map(value => zio.aws.ssm.model.primitives.StringDateTime(value))
    override val executionElapsedTime: Optional[StringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionElapsedTime())
        .map(value => zio.aws.ssm.model.primitives.StringDateTime(value))
    override val executionEndDateTime: Optional[StringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionEndDateTime())
        .map(value => zio.aws.ssm.model.primitives.StringDateTime(value))
    override val status: Optional[zio.aws.ssm.model.CommandInvocationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.CommandInvocationStatus.wrap(value))
    override val statusDetails: Optional[StatusDetails] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDetails())
      .map(value => zio.aws.ssm.model.primitives.StatusDetails(value))
    override val standardOutputContent: Optional[StandardOutputContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardOutputContent())
        .map(value => zio.aws.ssm.model.primitives.StandardOutputContent(value))
    override val standardOutputUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.standardOutputUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val standardErrorContent: Optional[StandardErrorContent] =
      zio.aws.core.internal
        .optionalFromNullable(impl.standardErrorContent())
        .map(value => zio.aws.ssm.model.primitives.StandardErrorContent(value))
    override val standardErrorUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.standardErrorUrl())
      .map(value => zio.aws.ssm.model.primitives.Url(value))
    override val cloudWatchOutputConfig
        : Optional[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchOutputConfig())
        .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse
  ): zio.aws.ssm.model.GetCommandInvocationResponse.ReadOnly = new Wrapper(impl)
}
