package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ComplianceStatus {
  def unwrap: software.amazon.awssdk.services.ssm.model.ComplianceStatus
}
object ComplianceStatus {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ComplianceStatus
  ): zio.aws.ssm.model.ComplianceStatus = value match {
    case software.amazon.awssdk.services.ssm.model.ComplianceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceStatus.COMPLIANT =>
      val r = COMPLIANT
      r
    case software.amazon.awssdk.services.ssm.model.ComplianceStatus.NON_COMPLIANT =>
      val r = NON_COMPLIANT
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceStatus =
      software.amazon.awssdk.services.ssm.model.ComplianceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLIANT extends zio.aws.ssm.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceStatus =
      software.amazon.awssdk.services.ssm.model.ComplianceStatus.COMPLIANT
  }
  case object NON_COMPLIANT extends zio.aws.ssm.model.ComplianceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ComplianceStatus =
      software.amazon.awssdk.services.ssm.model.ComplianceStatus.NON_COMPLIANT
  }
}
