package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{SharedDocumentVersion, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountSharingInfo(
    accountId: Optional[AccountId] = Optional.Absent,
    sharedDocumentVersion: Optional[SharedDocumentVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AccountSharingInfo = {
    import AccountSharingInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AccountSharingInfo
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        sharedDocumentVersion.map(value =>
          SharedDocumentVersion.unwrap(value): java.lang.String
        )
      )(_.sharedDocumentVersion)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AccountSharingInfo.ReadOnly =
    zio.aws.ssm.model.AccountSharingInfo.wrap(buildAwsValue())
}
object AccountSharingInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AccountSharingInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AccountSharingInfo =
      zio.aws.ssm.model.AccountSharingInfo(
        accountId.map(value => value),
        sharedDocumentVersion.map(value => value)
      )
    def accountId: Optional[AccountId]
    def sharedDocumentVersion: Optional[SharedDocumentVersion]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSharedDocumentVersion: ZIO[Any, AwsError, SharedDocumentVersion] =
      AwsError.unwrapOptionField("sharedDocumentVersion", sharedDocumentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AccountSharingInfo
  ) extends zio.aws.ssm.model.AccountSharingInfo.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.ssm.model.primitives.AccountId(value))
    override val sharedDocumentVersion: Optional[SharedDocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sharedDocumentVersion())
        .map(value => zio.aws.ssm.model.primitives.SharedDocumentVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AccountSharingInfo
  ): zio.aws.ssm.model.AccountSharingInfo.ReadOnly = new Wrapper(impl)
}
