package zio.aws.ssm.model
import scala.jdk.CollectionConverters._
sealed trait ParametersFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.ParametersFilterKey
}
object ParametersFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.ParametersFilterKey
  ): zio.aws.ssm.model.ParametersFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.ParametersFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.ParametersFilterKey.NAME =>
      val r = Name
      r
    case software.amazon.awssdk.services.ssm.model.ParametersFilterKey.TYPE =>
      val r = Type
      r
    case software.amazon.awssdk.services.ssm.model.ParametersFilterKey.KEY_ID =>
      val r = KeyId
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.ParametersFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParametersFilterKey =
      software.amazon.awssdk.services.ssm.model.ParametersFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object Name extends zio.aws.ssm.model.ParametersFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParametersFilterKey =
      software.amazon.awssdk.services.ssm.model.ParametersFilterKey.NAME
  }
  case object Type extends zio.aws.ssm.model.ParametersFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParametersFilterKey =
      software.amazon.awssdk.services.ssm.model.ParametersFilterKey.TYPE
  }
  case object KeyId extends zio.aws.ssm.model.ParametersFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.ParametersFilterKey =
      software.amazon.awssdk.services.ssm.model.ParametersFilterKey.KEY_ID
  }
}
