package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.OpsItemRelatedItemsFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OpsItemRelatedItemsFilter(
    key: zio.aws.ssm.model.OpsItemRelatedItemsFilterKey,
    values: Iterable[OpsItemRelatedItemsFilterValue],
    operator: zio.aws.ssm.model.OpsItemRelatedItemsFilterOperator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter = {
    import OpsItemRelatedItemsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter
      .builder()
      .key(key.unwrap)
      .values(values.map { item =>
        OpsItemRelatedItemsFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly =
    zio.aws.ssm.model.OpsItemRelatedItemsFilter.wrap(buildAwsValue())
}
object OpsItemRelatedItemsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsItemRelatedItemsFilter =
      zio.aws.ssm.model.OpsItemRelatedItemsFilter(key, values, operator)
    def key: zio.aws.ssm.model.OpsItemRelatedItemsFilterKey
    def values: List[OpsItemRelatedItemsFilterValue]
    def operator: zio.aws.ssm.model.OpsItemRelatedItemsFilterOperator
    def getKey
        : ZIO[Any, Nothing, zio.aws.ssm.model.OpsItemRelatedItemsFilterKey] =
      ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[OpsItemRelatedItemsFilterValue]] =
      ZIO.succeed(values)
    def getOperator: ZIO[
      Any,
      Nothing,
      zio.aws.ssm.model.OpsItemRelatedItemsFilterOperator
    ] = ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter
  ) extends zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly {
    override val key: zio.aws.ssm.model.OpsItemRelatedItemsFilterKey =
      zio.aws.ssm.model.OpsItemRelatedItemsFilterKey.wrap(impl.key())
    override val values: List[OpsItemRelatedItemsFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.OpsItemRelatedItemsFilterValue(item)
      }
      .toList
    override val operator: zio.aws.ssm.model.OpsItemRelatedItemsFilterOperator =
      zio.aws.ssm.model.OpsItemRelatedItemsFilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemsFilter
  ): zio.aws.ssm.model.OpsItemRelatedItemsFilter.ReadOnly = new Wrapper(impl)
}
