package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  OpsAggregatorValue,
  OpsAggregatorValueKey,
  OpsAggregatorType,
  OpsDataAttributeName,
  OpsDataTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OpsAggregator(
    aggregatorType: Optional[OpsAggregatorType] = Optional.Absent,
    typeName: Optional[OpsDataTypeName] = Optional.Absent,
    attributeName: Optional[OpsDataAttributeName] = Optional.Absent,
    values: Optional[Map[OpsAggregatorValueKey, OpsAggregatorValue]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.OpsFilter]] = Optional.Absent,
    aggregators: Optional[Iterable[zio.aws.ssm.model.OpsAggregator]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.OpsAggregator = {
    import OpsAggregator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsAggregator
      .builder()
      .optionallyWith(
        aggregatorType.map(value =>
          OpsAggregatorType.unwrap(value): java.lang.String
        )
      )(_.aggregatorType)
      .optionallyWith(
        typeName.map(value => OpsDataTypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        attributeName.map(value =>
          OpsDataAttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        values.map(value =>
          value
            .map({ case (key, value) =>
              (OpsAggregatorValueKey.unwrap(
                key
              ): java.lang.String) -> (OpsAggregatorValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.values)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        aggregators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregators)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsAggregator.ReadOnly =
    zio.aws.ssm.model.OpsAggregator.wrap(buildAwsValue())
}
object OpsAggregator {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsAggregator] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsAggregator =
      zio.aws.ssm.model.OpsAggregator(
        aggregatorType.map(value => value),
        typeName.map(value => value),
        attributeName.map(value => value),
        values.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aggregators.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def aggregatorType: Optional[OpsAggregatorType]
    def typeName: Optional[OpsDataTypeName]
    def attributeName: Optional[OpsDataAttributeName]
    def values: Optional[Map[OpsAggregatorValueKey, OpsAggregatorValue]]
    def filters: Optional[List[zio.aws.ssm.model.OpsFilter.ReadOnly]]
    def aggregators: Optional[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]]
    def getAggregatorType: ZIO[Any, AwsError, OpsAggregatorType] =
      AwsError.unwrapOptionField("aggregatorType", aggregatorType)
    def getTypeName: ZIO[Any, AwsError, OpsDataTypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getAttributeName: ZIO[Any, AwsError, OpsDataAttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getValues
        : ZIO[Any, AwsError, Map[OpsAggregatorValueKey, OpsAggregatorValue]] =
      AwsError.unwrapOptionField("values", values)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAggregators
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] =
      AwsError.unwrapOptionField("aggregators", aggregators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsAggregator
  ) extends zio.aws.ssm.model.OpsAggregator.ReadOnly {
    override val aggregatorType: Optional[OpsAggregatorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregatorType())
        .map(value => zio.aws.ssm.model.primitives.OpsAggregatorType(value))
    override val typeName: Optional[OpsDataTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.ssm.model.primitives.OpsDataTypeName(value))
    override val attributeName: Optional[OpsDataAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeName())
        .map(value => zio.aws.ssm.model.primitives.OpsDataAttributeName(value))
    override val values
        : Optional[Map[OpsAggregatorValueKey, OpsAggregatorValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives.OpsAggregatorValueKey(
                key
              ) -> zio.aws.ssm.model.primitives.OpsAggregatorValue(value)
            })
            .toMap
        )
    override val filters: Optional[List[zio.aws.ssm.model.OpsFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsFilter.wrap(item)
          }.toList
        )
    override val aggregators
        : Optional[List[zio.aws.ssm.model.OpsAggregator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.OpsAggregator.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsAggregator
  ): zio.aws.ssm.model.OpsAggregator.ReadOnly = new Wrapper(impl)
}
