package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{InstanceCount, StatusName}
import scala.jdk.CollectionConverters._
final case class InstanceAggregatedAssociationOverview(
    detailedStatus: Optional[StatusName] = Optional.Absent,
    instanceAssociationStatusAggregatedCount: Optional[
      Map[StatusName, InstanceCount]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview = {
    import InstanceAggregatedAssociationOverview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview
      .builder()
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        instanceAssociationStatusAggregatedCount.map(value =>
          value
            .map({ case (key, value) =>
              (StatusName.unwrap(key): java.lang.String) -> (InstanceCount
                .unwrap(value): Integer)
            })
            .asJava
        )
      )(_.instanceAssociationStatusAggregatedCount)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly =
    zio.aws.ssm.model.InstanceAggregatedAssociationOverview
      .wrap(buildAwsValue())
}
object InstanceAggregatedAssociationOverview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.InstanceAggregatedAssociationOverview =
      zio.aws.ssm.model.InstanceAggregatedAssociationOverview(
        detailedStatus.map(value => value),
        instanceAssociationStatusAggregatedCount.map(value => value)
      )
    def detailedStatus: Optional[StatusName]
    def instanceAssociationStatusAggregatedCount
        : Optional[Map[StatusName, InstanceCount]]
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getInstanceAssociationStatusAggregatedCount
        : ZIO[Any, AwsError, Map[StatusName, InstanceCount]] =
      AwsError.unwrapOptionField(
        "instanceAssociationStatusAggregatedCount",
        instanceAssociationStatusAggregatedCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview
  ) extends zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly {
    override val detailedStatus: Optional[StatusName] = zio.aws.core.internal
      .optionalFromNullable(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val instanceAssociationStatusAggregatedCount
        : Optional[Map[StatusName, InstanceCount]] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceAssociationStatusAggregatedCount())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.StatusName(
              key
            ) -> zio.aws.ssm.model.primitives.InstanceCount(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.InstanceAggregatedAssociationOverview
  ): zio.aws.ssm.model.InstanceAggregatedAssociationOverview.ReadOnly =
    new Wrapper(impl)
}
