package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.PSParameterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteParametersResponse(
    deletedParameters: Optional[Iterable[PSParameterName]] = Optional.Absent,
    invalidParameters: Optional[Iterable[PSParameterName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteParametersResponse = {
    import DeleteParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteParametersResponse
      .builder()
      .optionallyWith(
        deletedParameters.map(value =>
          value.map { item =>
            PSParameterName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deletedParameters)
      .optionallyWith(
        invalidParameters.map(value =>
          value.map { item =>
            PSParameterName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidParameters)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteParametersResponse.ReadOnly =
    zio.aws.ssm.model.DeleteParametersResponse.wrap(buildAwsValue())
}
object DeleteParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteParametersResponse =
      zio.aws.ssm.model.DeleteParametersResponse(
        deletedParameters.map(value => value),
        invalidParameters.map(value => value)
      )
    def deletedParameters: Optional[List[PSParameterName]]
    def invalidParameters: Optional[List[PSParameterName]]
    def getDeletedParameters: ZIO[Any, AwsError, List[PSParameterName]] =
      AwsError.unwrapOptionField("deletedParameters", deletedParameters)
    def getInvalidParameters: ZIO[Any, AwsError, List[PSParameterName]] =
      AwsError.unwrapOptionField("invalidParameters", invalidParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteParametersResponse
  ) extends zio.aws.ssm.model.DeleteParametersResponse.ReadOnly {
    override val deletedParameters: Optional[List[PSParameterName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletedParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PSParameterName(item)
          }.toList
        )
    override val invalidParameters: Optional[List[PSParameterName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.PSParameterName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteParametersResponse
  ): zio.aws.ssm.model.DeleteParametersResponse.ReadOnly = new Wrapper(impl)
}
